// chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_events.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_EVENTS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_EVENTS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_events.mojom-shared-internal.h"
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_data_model.mojom-shared.h"
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_types.mojom-shared.h"


namespace tabs_api::mojom {
class OnTabsCreatedEventDataView;

class OnTabsClosedEventDataView;

class OnDataChangedEventDataView;

class OnCollectionCreatedEventDataView;

class OnNodeMovedEventDataView;



}  // tabs_api::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tabs_api::mojom::OnTabsCreatedEventDataView> {
  using Data = ::tabs_api::mojom::internal::OnTabsCreatedEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::OnTabsClosedEventDataView> {
  using Data = ::tabs_api::mojom::internal::OnTabsClosedEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::OnDataChangedEventDataView> {
  using Data = ::tabs_api::mojom::internal::OnDataChangedEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::OnCollectionCreatedEventDataView> {
  using Data = ::tabs_api::mojom::internal::OnCollectionCreatedEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::OnNodeMovedEventDataView> {
  using Data = ::tabs_api::mojom::internal::OnNodeMovedEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace tabs_api::mojom {


class OnTabsCreatedEventDataView {
 public:
  OnTabsCreatedEventDataView() = default;

  OnTabsCreatedEventDataView(
      internal::OnTabsCreatedEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTabsDataView(
      mojo::ArrayDataView<::tabs_api::mojom::TabCreatedContainerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabs(UserType* output) {
    
    auto* pointer = data_->tabs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tabs_api::mojom::TabCreatedContainerDataView>>(
        pointer, output, message_);
  }
 private:
  internal::OnTabsCreatedEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OnTabsClosedEventDataView {
 public:
  OnTabsClosedEventDataView() = default;

  OnTabsClosedEventDataView(
      internal::OnTabsClosedEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTabsDataView(
      mojo::ArrayDataView<::tabs_api::mojom::NodeIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabs(UserType* output) {
    
    auto* pointer = data_->tabs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tabs_api::mojom::NodeIdDataView>>(
        pointer, output, message_);
  }
 private:
  internal::OnTabsClosedEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OnDataChangedEventDataView {
 public:
  OnDataChangedEventDataView() = default;

  OnDataChangedEventDataView(
      internal::OnDataChangedEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::tabs_api::mojom::DataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::tabs_api::mojom::DataDataView>(
        pointer, output, message_);
  }
 private:
  internal::OnDataChangedEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OnCollectionCreatedEventDataView {
 public:
  OnCollectionCreatedEventDataView() = default;

  OnCollectionCreatedEventDataView(
      internal::OnCollectionCreatedEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::tabs_api::mojom::DataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::tabs_api::mojom::DataDataView>(
        pointer, output, message_);
  }
  inline void GetPositionDataView(
      ::tabs_api::mojom::PositionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) {
    
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::PositionDataView>(
        pointer, output, message_);
  }
 private:
  internal::OnCollectionCreatedEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OnNodeMovedEventDataView {
 public:
  OnNodeMovedEventDataView() = default;

  OnNodeMovedEventDataView(
      internal::OnNodeMovedEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::tabs_api::mojom::NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetFromDataView(
      ::tabs_api::mojom::PositionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrom(UserType* output) {
    
    auto* pointer = data_->from.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::PositionDataView>(
        pointer, output, message_);
  }
  inline void GetToDataView(
      ::tabs_api::mojom::PositionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTo(UserType* output) {
    
    auto* pointer = data_->to.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::PositionDataView>(
        pointer, output, message_);
  }
 private:
  internal::OnNodeMovedEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // tabs_api::mojom

#endif  // CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_EVENTS_MOJOM_DATA_VIEW_H_