// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import './icons.html.js';
import { getFaviconForPageURL } from '//resources/js/icon.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { BookmarkType } from './bookmark_bar.mojom-webui.js';
import { getCss } from './bookmark_element.css.js';
import { getHtml } from './bookmark_element.html.js';
export class BookmarkElement extends CrLitElement {
    static get is() {
        return 'webui-browser-bookmark-element';
    }
    static get properties() {
        return {
            bookmarkTitle_: { type: String },
        };
    }
    bookmarkId;
    #bookmarkTitle__accessor_storage;
    get bookmarkTitle_() { return this.#bookmarkTitle__accessor_storage; }
    set bookmarkTitle_(value) { this.#bookmarkTitle__accessor_storage = value; }
    bookmarkType_;
    static defaultFavIconUrl_ = 'url(chrome://favicon2/)';
    faviconUrl_ = BookmarkElement.defaultFavIconUrl_;
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    constructor(data) {
        super();
        this.bookmarkTitle_ = data.title;
        this.bookmarkId = data.id;
        this.bookmarkType_ = data.type;
        this.updateFavIcon(data.pageUrlForFavicon);
    }
    update(changedProperties) {
        if (this.bookmarkType_ !== BookmarkType.FOLDER) {
            this.style.setProperty('--favicon-url', `${this.faviconUrl_}`);
        }
        super.update(changedProperties);
    }
    updateFavIcon(pageUrlForFavicon) {
        // getFaviconForPageURL, given a page URL, will construct a
        // chrome://favicon2/ URL that will request the icon from our local
        // cache considering sizes, resolution, etc.
        if (pageUrlForFavicon) {
            this.faviconUrl_ = getFaviconForPageURL(pageUrlForFavicon.url, false);
        }
        else {
            this.faviconUrl_ = BookmarkElement.defaultFavIconUrl_;
        }
    }
    handleClick_(e) {
        e = e || window.event;
        e.preventDefault();
        // Only launch the bookmark if it's a URL.
        if (this.bookmarkType_ === BookmarkType.URL) {
            this.dispatchEvent(new CustomEvent('bookmark-click', {
                bubbles: true,
                composed: true,
                detail: { bookmarkId: this.bookmarkId },
            }));
        }
    }
}
customElements.define(BookmarkElement.is, BookmarkElement);
