// chrome/browser/ui/webui_browser/bookmark_bar.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const BookmarkTypeSpec = { $: mojo.internal.Enum() };
export var BookmarkType;
(function (BookmarkType) {
    BookmarkType[BookmarkType["MIN_VALUE"] = 0] = "MIN_VALUE";
    BookmarkType[BookmarkType["MAX_VALUE"] = 4] = "MAX_VALUE";
    BookmarkType[BookmarkType["URL"] = 0] = "URL";
    BookmarkType[BookmarkType["FOLDER"] = 1] = "FOLDER";
    BookmarkType[BookmarkType["BOOKMARK_BAR"] = 2] = "BOOKMARK_BAR";
    BookmarkType[BookmarkType["OTHER_NODE"] = 3] = "OTHER_NODE";
    BookmarkType[BookmarkType["MOBILE"] = 4] = "MOBILE";
})(BookmarkType || (BookmarkType = {}));
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'bookmark_bar.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "bookmark_bar.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'bookmark_bar.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getBookmarkBar() {
        return this.proxy.sendMessage(0, PageHandler_GetBookmarkBar_ParamsSpec.$, PageHandler_GetBookmarkBar_ResponseParamsSpec.$, [], false);
    }
    openInNewTab(nodeId) {
        this.proxy.sendMessage(1, PageHandler_OpenInNewTab_ParamsSpec.$, null, [
            nodeId
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_GetBookmarkBar_ParamsSpec.$, PageHandler_GetBookmarkBar_ResponseParamsSpec.$, impl.getBookmarkBar.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_OpenInNewTab_ParamsSpec.$, null, impl.openInNewTab.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "bookmark_bar.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getBookmarkBar;
    openInNewTab;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getBookmarkBar =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_GetBookmarkBar_ParamsSpec.$, PageHandler_GetBookmarkBar_ResponseParamsSpec.$, this.getBookmarkBar.createReceiverHandler(true /* expectsResponse */), false);
        this.openInNewTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_OpenInNewTab_ParamsSpec.$, null, this.openInNewTab.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'bookmark_bar.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    bookmarkLoaded() {
        this.proxy.sendMessage(0, Page_BookmarkLoaded_ParamsSpec.$, null, [], false);
    }
    favIconChanged(bookmarkData) {
        this.proxy.sendMessage(1, Page_FavIconChanged_ParamsSpec.$, null, [
            bookmarkData
        ], false);
    }
    show() {
        this.proxy.sendMessage(2, Page_Show_ParamsSpec.$, null, [], false);
    }
    hide() {
        this.proxy.sendMessage(3, Page_Hide_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_BookmarkLoaded_ParamsSpec.$, null, impl.bookmarkLoaded.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_FavIconChanged_ParamsSpec.$, null, impl.favIconChanged.bind(impl), false);
        this.helper_internal_.registerHandler(2, Page_Show_ParamsSpec.$, null, impl.show.bind(impl), false);
        this.helper_internal_.registerHandler(3, Page_Hide_ParamsSpec.$, null, impl.hide.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "bookmark_bar.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    bookmarkLoaded;
    favIconChanged;
    show;
    hide;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.bookmarkLoaded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_BookmarkLoaded_ParamsSpec.$, null, this.bookmarkLoaded.createReceiverHandler(false /* expectsResponse */), false);
        this.favIconChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_FavIconChanged_ParamsSpec.$, null, this.favIconChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.show =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Page_Show_ParamsSpec.$, null, this.show.createReceiverHandler(false /* expectsResponse */), false);
        this.hide =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Page_Hide_ParamsSpec.$, null, this.hide.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const BookmarkDataSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_GetBookmarkBar_ParamsSpec = { $: {} };
export const PageHandler_GetBookmarkBar_ResponseParamsSpec = { $: {} };
export const PageHandler_OpenInNewTab_ParamsSpec = { $: {} };
export const Page_BookmarkLoaded_ParamsSpec = { $: {} };
export const Page_FavIconChanged_ParamsSpec = { $: {} };
export const Page_Show_ParamsSpec = { $: {} };
export const Page_Hide_ParamsSpec = { $: {} };
mojo.internal.Struct(BookmarkDataSpec.$, 'BookmarkData', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 16, 0, BookmarkTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageUrlForFavicon', 24, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetBookmarkBar_ParamsSpec.$, 'PageHandler_GetBookmarkBar_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetBookmarkBar_ResponseParamsSpec.$, 'PageHandler_GetBookmarkBar_ResponseParams', [
    mojo.internal.StructField('bookmarks', 0, 0, mojo.internal.Array(BookmarkDataSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OpenInNewTab_ParamsSpec.$, 'PageHandler_OpenInNewTab_Params', [
    mojo.internal.StructField('nodeId', 0, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_BookmarkLoaded_ParamsSpec.$, 'Page_BookmarkLoaded_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_FavIconChanged_ParamsSpec.$, 'Page_FavIconChanged_Params', [
    mojo.internal.StructField('bookmarkData', 0, 0, BookmarkDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_Show_ParamsSpec.$, 'Page_Show_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_Hide_ParamsSpec.$, 'Page_Hide_Params', [], [[0, 8],]);
