// chrome/browser/ui/webui_browser/browser.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  NodeIdSpec as tabsApi_mojom_NodeIdSpec,
  NodeId as tabsApi_mojom_NodeId
} from './tab_strip_api_types.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const SecurityIconSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SecurityIcon {

  MIN_VALUE = 0,
  MAX_VALUE = 8,
  HttpChromeRefresh = 0,
  SecurePageInfoChromeRefresh = 1,
  NoEncryption = 2,
  NotSecureWarningChromeRefresh = 3,
  BusinessChromeRefresh = 4,
  DangerousChromeRefresh = 5,
  ProductChromeRefresh = 6,
  ExtensionChromeRefresh = 7,
  OfflinePin = 8,
}



export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'webui_browser.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "webui_browser.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'webui_browser.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  setFocusToLocationBar(isUserInitiated: boolean): void;
  setReloadStopState(isLoading: boolean): void;
  showSidePanel(guestContentsId: number, title: string): void;
  closeSidePanel(): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setFocusToLocationBar(
      isUserInitiated: boolean): void {
    this.proxy.sendMessage(
        0,
        Page_SetFocusToLocationBar_ParamsSpec.$,
        null,
        [
          isUserInitiated
        ],
        false);
  }

  setReloadStopState(
      isLoading: boolean): void {
    this.proxy.sendMessage(
        1,
        Page_SetReloadStopState_ParamsSpec.$,
        null,
        [
          isLoading
        ],
        false);
  }

  showSidePanel(
      guestContentsId: number,
      title: string): void {
    this.proxy.sendMessage(
        2,
        Page_ShowSidePanel_ParamsSpec.$,
        null,
        [
          guestContentsId,
          title
        ],
        false);
  }

  closeSidePanel(): void {
    this.proxy.sendMessage(
        3,
        Page_CloseSidePanel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_SetFocusToLocationBar_ParamsSpec.$,
        null,
        impl.setFocusToLocationBar.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_SetReloadStopState_ParamsSpec.$,
        null,
        impl.setReloadStopState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_ShowSidePanel_ParamsSpec.$,
        null,
        impl.showSidePanel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Page_CloseSidePanel_ParamsSpec.$,
        null,
        impl.closeSidePanel.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "webui_browser.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setFocusToLocationBar: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setReloadStopState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showSidePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closeSidePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setFocusToLocationBar =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_SetFocusToLocationBar_ParamsSpec.$,
        null,
        this.setFocusToLocationBar.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setReloadStopState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_SetReloadStopState_ParamsSpec.$,
        null,
        this.setReloadStopState.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showSidePanel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_ShowSidePanel_ParamsSpec.$,
        null,
        this.showSidePanel.createReceiverHandler(false /* expectsResponse */),
        false);
    this.closeSidePanel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Page_CloseSidePanel_ParamsSpec.$,
        null,
        this.closeSidePanel.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'webui_browser.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getGuestIdForTabId(tabId: tabsApi_mojom_NodeId, handler: GuestHandlerPendingReceiver): Promise<{
        guestId: number, }>;
  loadTabSearch(): Promise<{
        guestId: number, }>;
  showTabSearchBubble(anchorName: string): void;
  openAppMenu(): void;
  openProfileMenu(): void;
  launchDevToolsForBrowser(): void;
  onSidePanelClosed(): void;
  minimize(): void;
  maximize(): void;
  restore(): void;
  close(): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getGuestIdForTabId(
      tabId: tabsApi_mojom_NodeId,
      handler: GuestHandlerPendingReceiver): Promise<{
        guestId: number, }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_GetGuestIdForTabId_ParamsSpec.$,
        PageHandler_GetGuestIdForTabId_ResponseParamsSpec.$,
        [
          tabId,
          handler
        ],
        false);
  }

  loadTabSearch(): Promise<{
        guestId: number, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_LoadTabSearch_ParamsSpec.$,
        PageHandler_LoadTabSearch_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  showTabSearchBubble(
      anchorName: string): void {
    this.proxy.sendMessage(
        2,
        PageHandler_ShowTabSearchBubble_ParamsSpec.$,
        null,
        [
          anchorName
        ],
        false);
  }

  openAppMenu(): void {
    this.proxy.sendMessage(
        3,
        PageHandler_OpenAppMenu_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openProfileMenu(): void {
    this.proxy.sendMessage(
        4,
        PageHandler_OpenProfileMenu_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  launchDevToolsForBrowser(): void {
    this.proxy.sendMessage(
        5,
        PageHandler_LaunchDevToolsForBrowser_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onSidePanelClosed(): void {
    this.proxy.sendMessage(
        6,
        PageHandler_OnSidePanelClosed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  minimize(): void {
    this.proxy.sendMessage(
        7,
        PageHandler_Minimize_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  maximize(): void {
    this.proxy.sendMessage(
        8,
        PageHandler_Maximize_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  restore(): void {
    this.proxy.sendMessage(
        9,
        PageHandler_Restore_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  close(): void {
    this.proxy.sendMessage(
        10,
        PageHandler_Close_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetGuestIdForTabId_ParamsSpec.$,
        PageHandler_GetGuestIdForTabId_ResponseParamsSpec.$,
        impl.getGuestIdForTabId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_LoadTabSearch_ParamsSpec.$,
        PageHandler_LoadTabSearch_ResponseParamsSpec.$,
        impl.loadTabSearch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_ShowTabSearchBubble_ParamsSpec.$,
        null,
        impl.showTabSearchBubble.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_OpenAppMenu_ParamsSpec.$,
        null,
        impl.openAppMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_OpenProfileMenu_ParamsSpec.$,
        null,
        impl.openProfileMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_LaunchDevToolsForBrowser_ParamsSpec.$,
        null,
        impl.launchDevToolsForBrowser.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_OnSidePanelClosed_ParamsSpec.$,
        null,
        impl.onSidePanelClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_Minimize_ParamsSpec.$,
        null,
        impl.minimize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_Maximize_ParamsSpec.$,
        null,
        impl.maximize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_Restore_ParamsSpec.$,
        null,
        impl.restore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageHandler_Close_ParamsSpec.$,
        null,
        impl.close.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "webui_browser.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getGuestIdForTabId: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  loadTabSearch: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showTabSearchBubble: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openAppMenu: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openProfileMenu: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  launchDevToolsForBrowser: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onSidePanelClosed: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  minimize: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  maximize: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  restore: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  close: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getGuestIdForTabId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetGuestIdForTabId_ParamsSpec.$,
        PageHandler_GetGuestIdForTabId_ResponseParamsSpec.$,
        this.getGuestIdForTabId.createReceiverHandler(true /* expectsResponse */),
        false);
    this.loadTabSearch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_LoadTabSearch_ParamsSpec.$,
        PageHandler_LoadTabSearch_ResponseParamsSpec.$,
        this.loadTabSearch.createReceiverHandler(true /* expectsResponse */),
        false);
    this.showTabSearchBubble =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_ShowTabSearchBubble_ParamsSpec.$,
        null,
        this.showTabSearchBubble.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openAppMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_OpenAppMenu_ParamsSpec.$,
        null,
        this.openAppMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openProfileMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_OpenProfileMenu_ParamsSpec.$,
        null,
        this.openProfileMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    this.launchDevToolsForBrowser =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_LaunchDevToolsForBrowser_ParamsSpec.$,
        null,
        this.launchDevToolsForBrowser.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onSidePanelClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_OnSidePanelClosed_ParamsSpec.$,
        null,
        this.onSidePanelClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    this.minimize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_Minimize_ParamsSpec.$,
        null,
        this.minimize.createReceiverHandler(false /* expectsResponse */),
        false);
    this.maximize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_Maximize_ParamsSpec.$,
        null,
        this.maximize.createReceiverHandler(false /* expectsResponse */),
        false);
    this.restore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_Restore_ParamsSpec.$,
        null,
        this.restore.createReceiverHandler(false /* expectsResponse */),
        false);
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageHandler_Close_ParamsSpec.$,
        null,
        this.close.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type GuestHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<GuestHandlerPendingReceiver>;

export class GuestHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<GuestHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<GuestHandlerPendingReceiver>;
  constructor(handle: MojoHandle|GuestHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'webui_browser.mojom.GuestHandler',
        scope);
  }
}

export interface GuestHandlerInterface {
  navigate(src: url_mojom_Url): void;
  canGoBack(): Promise<{
        canGoBack: boolean, }>;
  goBack(): void;
  canGoForward(): Promise<{
        canGoForward: boolean, }>;
  goForward(): void;
  reload(): void;
  stopLoading(): void;
  openPageInfoMenu(): void;
  getSecurityIcon(): Promise<{
        securityIcon: SecurityIcon, }>;
}

export class GuestHandlerRemote implements GuestHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<GuestHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<GuestHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|GuestHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GuestHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  navigate(
      src: url_mojom_Url): void {
    this.proxy.sendMessage(
        0,
        GuestHandler_Navigate_ParamsSpec.$,
        null,
        [
          src
        ],
        false);
  }

  canGoBack(): Promise<{
        canGoBack: boolean, }> {
    return this.proxy.sendMessage(
        1,
        GuestHandler_CanGoBack_ParamsSpec.$,
        GuestHandler_CanGoBack_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  goBack(): void {
    this.proxy.sendMessage(
        2,
        GuestHandler_GoBack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  canGoForward(): Promise<{
        canGoForward: boolean, }> {
    return this.proxy.sendMessage(
        3,
        GuestHandler_CanGoForward_ParamsSpec.$,
        GuestHandler_CanGoForward_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  goForward(): void {
    this.proxy.sendMessage(
        4,
        GuestHandler_GoForward_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  reload(): void {
    this.proxy.sendMessage(
        5,
        GuestHandler_Reload_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  stopLoading(): void {
    this.proxy.sendMessage(
        6,
        GuestHandler_StopLoading_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openPageInfoMenu(): void {
    this.proxy.sendMessage(
        7,
        GuestHandler_OpenPageInfoMenu_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getSecurityIcon(): Promise<{
        securityIcon: SecurityIcon, }> {
    return this.proxy.sendMessage(
        8,
        GuestHandler_GetSecurityIcon_ParamsSpec.$,
        GuestHandler_GetSecurityIcon_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GuestHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GuestHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GuestHandlerRemote, GuestHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GuestHandlerRemote, GuestHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: GuestHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GuestHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GuestHandler_Navigate_ParamsSpec.$,
        null,
        impl.navigate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        GuestHandler_CanGoBack_ParamsSpec.$,
        GuestHandler_CanGoBack_ResponseParamsSpec.$,
        impl.canGoBack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        GuestHandler_GoBack_ParamsSpec.$,
        null,
        impl.goBack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        GuestHandler_CanGoForward_ParamsSpec.$,
        GuestHandler_CanGoForward_ResponseParamsSpec.$,
        impl.canGoForward.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        GuestHandler_GoForward_ParamsSpec.$,
        null,
        impl.goForward.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        GuestHandler_Reload_ParamsSpec.$,
        null,
        impl.reload.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        GuestHandler_StopLoading_ParamsSpec.$,
        null,
        impl.stopLoading.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        GuestHandler_OpenPageInfoMenu_ParamsSpec.$,
        null,
        impl.openPageInfoMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        GuestHandler_GetSecurityIcon_ParamsSpec.$,
        GuestHandler_GetSecurityIcon_ResponseParamsSpec.$,
        impl.getSecurityIcon.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GuestHandler {
  static get $interfaceName(): string {
    return "webui_browser.mojom.GuestHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): GuestHandlerRemote {
    let remote = new GuestHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the GuestHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GuestHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GuestHandlerRemote, GuestHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GuestHandlerRemote, GuestHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  navigate: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  canGoBack: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  goBack: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  canGoForward: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  goForward: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  reload: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  stopLoading: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openPageInfoMenu: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getSecurityIcon: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GuestHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.navigate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GuestHandler_Navigate_ParamsSpec.$,
        null,
        this.navigate.createReceiverHandler(false /* expectsResponse */),
        false);
    this.canGoBack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        GuestHandler_CanGoBack_ParamsSpec.$,
        GuestHandler_CanGoBack_ResponseParamsSpec.$,
        this.canGoBack.createReceiverHandler(true /* expectsResponse */),
        false);
    this.goBack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        GuestHandler_GoBack_ParamsSpec.$,
        null,
        this.goBack.createReceiverHandler(false /* expectsResponse */),
        false);
    this.canGoForward =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        GuestHandler_CanGoForward_ParamsSpec.$,
        GuestHandler_CanGoForward_ResponseParamsSpec.$,
        this.canGoForward.createReceiverHandler(true /* expectsResponse */),
        false);
    this.goForward =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        GuestHandler_GoForward_ParamsSpec.$,
        null,
        this.goForward.createReceiverHandler(false /* expectsResponse */),
        false);
    this.reload =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        GuestHandler_Reload_ParamsSpec.$,
        null,
        this.reload.createReceiverHandler(false /* expectsResponse */),
        false);
    this.stopLoading =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        GuestHandler_StopLoading_ParamsSpec.$,
        null,
        this.stopLoading.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openPageInfoMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        GuestHandler_OpenPageInfoMenu_ParamsSpec.$,
        null,
        this.openPageInfoMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getSecurityIcon =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        GuestHandler_GetSecurityIcon_ParamsSpec.$,
        GuestHandler_GetSecurityIcon_ResponseParamsSpec.$,
        this.getSecurityIcon.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetFocusToLocationBar_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetReloadStopState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ShowSidePanel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_CloseSidePanel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetGuestIdForTabId_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetGuestIdForTabId_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_LoadTabSearch_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_LoadTabSearch_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowTabSearchBubble_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenAppMenu_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenProfileMenu_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_LaunchDevToolsForBrowser_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnSidePanelClosed_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Minimize_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Maximize_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Restore_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Close_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GuestHandler_Navigate_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GuestHandler_CanGoBack_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GuestHandler_CanGoBack_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GuestHandler_GoBack_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GuestHandler_CanGoForward_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GuestHandler_CanGoForward_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GuestHandler_GoForward_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GuestHandler_Reload_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GuestHandler_StopLoading_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GuestHandler_OpenPageInfoMenu_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GuestHandler_GetSecurityIcon_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GuestHandler_GetSecurityIcon_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Page_SetFocusToLocationBar_ParamsMojoType {
  isUserInitiated: boolean;
}


export type Page_SetFocusToLocationBar_Params = Page_SetFocusToLocationBar_ParamsMojoType;
mojo.internal.Struct<Page_SetFocusToLocationBar_ParamsMojoType>(
    Page_SetFocusToLocationBar_ParamsSpec.$,
    'Page_SetFocusToLocationBar_Params',
    [
      mojo.internal.StructField<Page_SetFocusToLocationBar_ParamsMojoType, boolean>(
        'isUserInitiated', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_SetReloadStopState_ParamsMojoType {
  isLoading: boolean;
}


export type Page_SetReloadStopState_Params = Page_SetReloadStopState_ParamsMojoType;
mojo.internal.Struct<Page_SetReloadStopState_ParamsMojoType>(
    Page_SetReloadStopState_ParamsSpec.$,
    'Page_SetReloadStopState_Params',
    [
      mojo.internal.StructField<Page_SetReloadStopState_ParamsMojoType, boolean>(
        'isLoading', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_ShowSidePanel_ParamsMojoType {
  guestContentsId: number;
  title: string;
}


export type Page_ShowSidePanel_Params = Page_ShowSidePanel_ParamsMojoType;
mojo.internal.Struct<Page_ShowSidePanel_ParamsMojoType>(
    Page_ShowSidePanel_ParamsSpec.$,
    'Page_ShowSidePanel_Params',
    [
      mojo.internal.StructField<Page_ShowSidePanel_ParamsMojoType, number>(
        'guestContentsId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_ShowSidePanel_ParamsMojoType, string>(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Page_CloseSidePanel_ParamsMojoType {
}


export type Page_CloseSidePanel_Params = Page_CloseSidePanel_ParamsMojoType;
mojo.internal.Struct<Page_CloseSidePanel_ParamsMojoType>(
    Page_CloseSidePanel_ParamsSpec.$,
    'Page_CloseSidePanel_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetGuestIdForTabId_ParamsMojoType {
  tabId: tabsApi_mojom_NodeId;
  handler: GuestHandlerPendingReceiver;
}


export type PageHandler_GetGuestIdForTabId_Params = PageHandler_GetGuestIdForTabId_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetGuestIdForTabId_ParamsMojoType>(
    PageHandler_GetGuestIdForTabId_ParamsSpec.$,
    'PageHandler_GetGuestIdForTabId_Params',
    [
      mojo.internal.StructField<PageHandler_GetGuestIdForTabId_ParamsMojoType, tabsApi_mojom_NodeId>(
        'tabId', 0,
        0,
        tabsApi_mojom_NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_GetGuestIdForTabId_ParamsMojoType, GuestHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(GuestHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetGuestIdForTabId_ResponseParamsMojoType {
  guestId: number;
}


export type PageHandler_GetGuestIdForTabId_ResponseParams = PageHandler_GetGuestIdForTabId_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetGuestIdForTabId_ResponseParamsMojoType>(
    PageHandler_GetGuestIdForTabId_ResponseParamsSpec.$,
    'PageHandler_GetGuestIdForTabId_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetGuestIdForTabId_ResponseParamsMojoType, number>(
        'guestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_LoadTabSearch_ParamsMojoType {
}


export type PageHandler_LoadTabSearch_Params = PageHandler_LoadTabSearch_ParamsMojoType;
mojo.internal.Struct<PageHandler_LoadTabSearch_ParamsMojoType>(
    PageHandler_LoadTabSearch_ParamsSpec.$,
    'PageHandler_LoadTabSearch_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_LoadTabSearch_ResponseParamsMojoType {
  guestId: number;
}


export type PageHandler_LoadTabSearch_ResponseParams = PageHandler_LoadTabSearch_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_LoadTabSearch_ResponseParamsMojoType>(
    PageHandler_LoadTabSearch_ResponseParamsSpec.$,
    'PageHandler_LoadTabSearch_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_LoadTabSearch_ResponseParamsMojoType, number>(
        'guestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ShowTabSearchBubble_ParamsMojoType {
  anchorName: string;
}


export type PageHandler_ShowTabSearchBubble_Params = PageHandler_ShowTabSearchBubble_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowTabSearchBubble_ParamsMojoType>(
    PageHandler_ShowTabSearchBubble_ParamsSpec.$,
    'PageHandler_ShowTabSearchBubble_Params',
    [
      mojo.internal.StructField<PageHandler_ShowTabSearchBubble_ParamsMojoType, string>(
        'anchorName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OpenAppMenu_ParamsMojoType {
}


export type PageHandler_OpenAppMenu_Params = PageHandler_OpenAppMenu_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenAppMenu_ParamsMojoType>(
    PageHandler_OpenAppMenu_ParamsSpec.$,
    'PageHandler_OpenAppMenu_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OpenProfileMenu_ParamsMojoType {
}


export type PageHandler_OpenProfileMenu_Params = PageHandler_OpenProfileMenu_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenProfileMenu_ParamsMojoType>(
    PageHandler_OpenProfileMenu_ParamsSpec.$,
    'PageHandler_OpenProfileMenu_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_LaunchDevToolsForBrowser_ParamsMojoType {
}


export type PageHandler_LaunchDevToolsForBrowser_Params = PageHandler_LaunchDevToolsForBrowser_ParamsMojoType;
mojo.internal.Struct<PageHandler_LaunchDevToolsForBrowser_ParamsMojoType>(
    PageHandler_LaunchDevToolsForBrowser_ParamsSpec.$,
    'PageHandler_LaunchDevToolsForBrowser_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OnSidePanelClosed_ParamsMojoType {
}


export type PageHandler_OnSidePanelClosed_Params = PageHandler_OnSidePanelClosed_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnSidePanelClosed_ParamsMojoType>(
    PageHandler_OnSidePanelClosed_ParamsSpec.$,
    'PageHandler_OnSidePanelClosed_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_Minimize_ParamsMojoType {
}


export type PageHandler_Minimize_Params = PageHandler_Minimize_ParamsMojoType;
mojo.internal.Struct<PageHandler_Minimize_ParamsMojoType>(
    PageHandler_Minimize_ParamsSpec.$,
    'PageHandler_Minimize_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_Maximize_ParamsMojoType {
}


export type PageHandler_Maximize_Params = PageHandler_Maximize_ParamsMojoType;
mojo.internal.Struct<PageHandler_Maximize_ParamsMojoType>(
    PageHandler_Maximize_ParamsSpec.$,
    'PageHandler_Maximize_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_Restore_ParamsMojoType {
}


export type PageHandler_Restore_Params = PageHandler_Restore_ParamsMojoType;
mojo.internal.Struct<PageHandler_Restore_ParamsMojoType>(
    PageHandler_Restore_ParamsSpec.$,
    'PageHandler_Restore_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_Close_ParamsMojoType {
}


export type PageHandler_Close_Params = PageHandler_Close_ParamsMojoType;
mojo.internal.Struct<PageHandler_Close_ParamsMojoType>(
    PageHandler_Close_ParamsSpec.$,
    'PageHandler_Close_Params',
    [
    ],
    [[0, 8],]);





export interface GuestHandler_Navigate_ParamsMojoType {
  src: url_mojom_Url;
}


export type GuestHandler_Navigate_Params = GuestHandler_Navigate_ParamsMojoType;
mojo.internal.Struct<GuestHandler_Navigate_ParamsMojoType>(
    GuestHandler_Navigate_ParamsSpec.$,
    'GuestHandler_Navigate_Params',
    [
      mojo.internal.StructField<GuestHandler_Navigate_ParamsMojoType, url_mojom_Url>(
        'src', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GuestHandler_CanGoBack_ParamsMojoType {
}


export type GuestHandler_CanGoBack_Params = GuestHandler_CanGoBack_ParamsMojoType;
mojo.internal.Struct<GuestHandler_CanGoBack_ParamsMojoType>(
    GuestHandler_CanGoBack_ParamsSpec.$,
    'GuestHandler_CanGoBack_Params',
    [
    ],
    [[0, 8],]);





export interface GuestHandler_CanGoBack_ResponseParamsMojoType {
  canGoBack: boolean;
}


export type GuestHandler_CanGoBack_ResponseParams = GuestHandler_CanGoBack_ResponseParamsMojoType;
mojo.internal.Struct<GuestHandler_CanGoBack_ResponseParamsMojoType>(
    GuestHandler_CanGoBack_ResponseParamsSpec.$,
    'GuestHandler_CanGoBack_ResponseParams',
    [
      mojo.internal.StructField<GuestHandler_CanGoBack_ResponseParamsMojoType, boolean>(
        'canGoBack', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GuestHandler_GoBack_ParamsMojoType {
}


export type GuestHandler_GoBack_Params = GuestHandler_GoBack_ParamsMojoType;
mojo.internal.Struct<GuestHandler_GoBack_ParamsMojoType>(
    GuestHandler_GoBack_ParamsSpec.$,
    'GuestHandler_GoBack_Params',
    [
    ],
    [[0, 8],]);





export interface GuestHandler_CanGoForward_ParamsMojoType {
}


export type GuestHandler_CanGoForward_Params = GuestHandler_CanGoForward_ParamsMojoType;
mojo.internal.Struct<GuestHandler_CanGoForward_ParamsMojoType>(
    GuestHandler_CanGoForward_ParamsSpec.$,
    'GuestHandler_CanGoForward_Params',
    [
    ],
    [[0, 8],]);





export interface GuestHandler_CanGoForward_ResponseParamsMojoType {
  canGoForward: boolean;
}


export type GuestHandler_CanGoForward_ResponseParams = GuestHandler_CanGoForward_ResponseParamsMojoType;
mojo.internal.Struct<GuestHandler_CanGoForward_ResponseParamsMojoType>(
    GuestHandler_CanGoForward_ResponseParamsSpec.$,
    'GuestHandler_CanGoForward_ResponseParams',
    [
      mojo.internal.StructField<GuestHandler_CanGoForward_ResponseParamsMojoType, boolean>(
        'canGoForward', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GuestHandler_GoForward_ParamsMojoType {
}


export type GuestHandler_GoForward_Params = GuestHandler_GoForward_ParamsMojoType;
mojo.internal.Struct<GuestHandler_GoForward_ParamsMojoType>(
    GuestHandler_GoForward_ParamsSpec.$,
    'GuestHandler_GoForward_Params',
    [
    ],
    [[0, 8],]);





export interface GuestHandler_Reload_ParamsMojoType {
}


export type GuestHandler_Reload_Params = GuestHandler_Reload_ParamsMojoType;
mojo.internal.Struct<GuestHandler_Reload_ParamsMojoType>(
    GuestHandler_Reload_ParamsSpec.$,
    'GuestHandler_Reload_Params',
    [
    ],
    [[0, 8],]);





export interface GuestHandler_StopLoading_ParamsMojoType {
}


export type GuestHandler_StopLoading_Params = GuestHandler_StopLoading_ParamsMojoType;
mojo.internal.Struct<GuestHandler_StopLoading_ParamsMojoType>(
    GuestHandler_StopLoading_ParamsSpec.$,
    'GuestHandler_StopLoading_Params',
    [
    ],
    [[0, 8],]);





export interface GuestHandler_OpenPageInfoMenu_ParamsMojoType {
}


export type GuestHandler_OpenPageInfoMenu_Params = GuestHandler_OpenPageInfoMenu_ParamsMojoType;
mojo.internal.Struct<GuestHandler_OpenPageInfoMenu_ParamsMojoType>(
    GuestHandler_OpenPageInfoMenu_ParamsSpec.$,
    'GuestHandler_OpenPageInfoMenu_Params',
    [
    ],
    [[0, 8],]);





export interface GuestHandler_GetSecurityIcon_ParamsMojoType {
}


export type GuestHandler_GetSecurityIcon_Params = GuestHandler_GetSecurityIcon_ParamsMojoType;
mojo.internal.Struct<GuestHandler_GetSecurityIcon_ParamsMojoType>(
    GuestHandler_GetSecurityIcon_ParamsSpec.$,
    'GuestHandler_GetSecurityIcon_Params',
    [
    ],
    [[0, 8],]);





export interface GuestHandler_GetSecurityIcon_ResponseParamsMojoType {
  securityIcon: SecurityIcon;
}


export type GuestHandler_GetSecurityIcon_ResponseParams = GuestHandler_GetSecurityIcon_ResponseParamsMojoType;
mojo.internal.Struct<GuestHandler_GetSecurityIcon_ResponseParamsMojoType>(
    GuestHandler_GetSecurityIcon_ResponseParamsSpec.$,
    'GuestHandler_GetSecurityIcon_ResponseParams',
    [
      mojo.internal.StructField<GuestHandler_GetSecurityIcon_ResponseParamsMojoType, SecurityIcon>(
        'securityIcon', 0,
        0,
        SecurityIconSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



