// services/device/public/mojom/usb_manager.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UsbDevicePendingReceiver as device_mojom_UsbDevicePendingReceiver,
  UsbDeviceClientRemote as device_mojom_UsbDeviceClientRemote,
  UsbDeviceInfoSpec as device_mojom_UsbDeviceInfoSpec,
  UsbDeviceInfo as device_mojom_UsbDeviceInfo
} from './usb_device.mojom-webui.js';
import {
  UsbEnumerationOptionsSpec as device_mojom_UsbEnumerationOptionsSpec,
  UsbEnumerationOptions as device_mojom_UsbEnumerationOptions
} from './usb_enumeration_options.mojom-webui.js';
import {
  UsbDeviceManagerClientRemote as device_mojom_UsbDeviceManagerClientRemote
} from './usb_manager_client.mojom-webui.js';







export type UsbDeviceManagerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<UsbDeviceManagerPendingReceiver>;

export class UsbDeviceManagerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<UsbDeviceManager> {

  handle: mojo.internal.interfaceSupport.Endpoint<UsbDeviceManagerPendingReceiver>;
  constructor(handle: MojoHandle|UsbDeviceManagerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'device.mojom.UsbDeviceManager',
        scope);
  }
}

export interface UsbDeviceManagerInterface {
  enumerateDevicesAndSetClient(client: object): Promise<{
        results: device_mojom_UsbDeviceInfo[], }>;
  getDevices(options: (device_mojom_UsbEnumerationOptions | null)): Promise<{
        results: device_mojom_UsbDeviceInfo[], }>;
  getDevice(guid: string, blockedInterfaceClasses: number[], deviceReceiver: device_mojom_UsbDevicePendingReceiver, deviceClient: (device_mojom_UsbDeviceClientRemote | null)): void;
  getSecurityKeyDevice(guid: string, deviceReceiver: device_mojom_UsbDevicePendingReceiver, deviceClient: (device_mojom_UsbDeviceClientRemote | null)): void;
  setClient(client: object): void;
}

export class UsbDeviceManagerRemote implements UsbDeviceManagerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<UsbDeviceManagerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<UsbDeviceManagerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|UsbDeviceManagerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UsbDeviceManagerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  enumerateDevicesAndSetClient(
      client: object): Promise<{
        results: device_mojom_UsbDeviceInfo[], }> {
    return this.proxy.sendMessage(
        0,
        UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsSpec.$,
        UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsSpec.$,
        [
          client
        ],
        false);
  }

  getDevices(
      options: (device_mojom_UsbEnumerationOptions | null)): Promise<{
        results: device_mojom_UsbDeviceInfo[], }> {
    return this.proxy.sendMessage(
        1,
        UsbDeviceManager_GetDevices_ParamsSpec.$,
        UsbDeviceManager_GetDevices_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  getDevice(
      guid: string,
      blockedInterfaceClasses: number[],
      deviceReceiver: device_mojom_UsbDevicePendingReceiver,
      deviceClient: (device_mojom_UsbDeviceClientRemote | null)): void {
    this.proxy.sendMessage(
        2,
        UsbDeviceManager_GetDevice_ParamsSpec.$,
        null,
        [
          guid,
          blockedInterfaceClasses,
          deviceReceiver,
          deviceClient
        ],
        false);
  }

  getSecurityKeyDevice(
      guid: string,
      deviceReceiver: device_mojom_UsbDevicePendingReceiver,
      deviceClient: (device_mojom_UsbDeviceClientRemote | null)): void {
    this.proxy.sendMessage(
        3,
        UsbDeviceManager_GetSecurityKeyDevice_ParamsSpec.$,
        null,
        [
          guid,
          deviceReceiver,
          deviceClient
        ],
        false);
  }

  setClient(
      client: object): void {
    this.proxy.sendMessage(
        4,
        UsbDeviceManager_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UsbDeviceManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UsbDeviceManagerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    UsbDeviceManagerRemote, UsbDeviceManagerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    UsbDeviceManagerRemote, UsbDeviceManagerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: UsbDeviceManagerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UsbDeviceManagerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsSpec.$,
        UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsSpec.$,
        impl.enumerateDevicesAndSetClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        UsbDeviceManager_GetDevices_ParamsSpec.$,
        UsbDeviceManager_GetDevices_ResponseParamsSpec.$,
        impl.getDevices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        UsbDeviceManager_GetDevice_ParamsSpec.$,
        null,
        impl.getDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        UsbDeviceManager_GetSecurityKeyDevice_ParamsSpec.$,
        null,
        impl.getSecurityKeyDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        UsbDeviceManager_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UsbDeviceManager {
  static get $interfaceName(): string {
    return "device.mojom.UsbDeviceManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): UsbDeviceManagerRemote {
    let remote = new UsbDeviceManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the UsbDeviceManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UsbDeviceManagerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    UsbDeviceManagerRemote, UsbDeviceManagerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    UsbDeviceManagerRemote, UsbDeviceManagerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  enumerateDevicesAndSetClient: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getDevices: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getDevice: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getSecurityKeyDevice: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setClient: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UsbDeviceManagerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.enumerateDevicesAndSetClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsSpec.$,
        UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsSpec.$,
        this.enumerateDevicesAndSetClient.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UsbDeviceManager_GetDevices_ParamsSpec.$,
        UsbDeviceManager_GetDevices_ResponseParamsSpec.$,
        this.getDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        UsbDeviceManager_GetDevice_ParamsSpec.$,
        null,
        this.getDevice.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getSecurityKeyDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        UsbDeviceManager_GetSecurityKeyDevice_ParamsSpec.$,
        null,
        this.getSecurityKeyDevice.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        UsbDeviceManager_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManager_GetDevices_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManager_GetDevices_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManager_GetDevice_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManager_GetSecurityKeyDevice_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManager_SetClient_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsMojoType {
  client: object;
}


export type UsbDeviceManager_EnumerateDevicesAndSetClient_Params = UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsMojoType;
mojo.internal.Struct<UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsMojoType>(
    UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsSpec.$,
    'UsbDeviceManager_EnumerateDevicesAndSetClient_Params',
    [
      mojo.internal.StructField<UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsMojoType, object>(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(device_mojom_UsbDeviceManagerClientRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsMojoType {
  results: device_mojom_UsbDeviceInfo[];
}


export type UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParams = UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsMojoType;
mojo.internal.Struct<UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsMojoType>(
    UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsSpec.$,
    'UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParams',
    [
      mojo.internal.StructField<UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsMojoType, device_mojom_UsbDeviceInfo[]>(
        'results', 0,
        0,
        mojo.internal.Array(device_mojom_UsbDeviceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDeviceManager_GetDevices_ParamsMojoType {
  options: (device_mojom_UsbEnumerationOptions | null);
}


export type UsbDeviceManager_GetDevices_Params = UsbDeviceManager_GetDevices_ParamsMojoType;
mojo.internal.Struct<UsbDeviceManager_GetDevices_ParamsMojoType>(
    UsbDeviceManager_GetDevices_ParamsSpec.$,
    'UsbDeviceManager_GetDevices_Params',
    [
      mojo.internal.StructField<UsbDeviceManager_GetDevices_ParamsMojoType, device_mojom_UsbEnumerationOptions>(
        'options', 0,
        0,
        device_mojom_UsbEnumerationOptionsSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDeviceManager_GetDevices_ResponseParamsMojoType {
  results: device_mojom_UsbDeviceInfo[];
}


export type UsbDeviceManager_GetDevices_ResponseParams = UsbDeviceManager_GetDevices_ResponseParamsMojoType;
mojo.internal.Struct<UsbDeviceManager_GetDevices_ResponseParamsMojoType>(
    UsbDeviceManager_GetDevices_ResponseParamsSpec.$,
    'UsbDeviceManager_GetDevices_ResponseParams',
    [
      mojo.internal.StructField<UsbDeviceManager_GetDevices_ResponseParamsMojoType, device_mojom_UsbDeviceInfo[]>(
        'results', 0,
        0,
        mojo.internal.Array(device_mojom_UsbDeviceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDeviceManager_GetDevice_ParamsMojoType {
  guid: string;
  blockedInterfaceClasses: number[];
  deviceReceiver: device_mojom_UsbDevicePendingReceiver;
  deviceClient: (device_mojom_UsbDeviceClientRemote | null);
}


export type UsbDeviceManager_GetDevice_Params = UsbDeviceManager_GetDevice_ParamsMojoType;
mojo.internal.Struct<UsbDeviceManager_GetDevice_ParamsMojoType>(
    UsbDeviceManager_GetDevice_ParamsSpec.$,
    'UsbDeviceManager_GetDevice_Params',
    [
      mojo.internal.StructField<UsbDeviceManager_GetDevice_ParamsMojoType, string>(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceManager_GetDevice_ParamsMojoType, number[]>(
        'blockedInterfaceClasses', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceManager_GetDevice_ParamsMojoType, device_mojom_UsbDevicePendingReceiver>(
        'deviceReceiver', 16,
        0,
        mojo.internal.InterfaceRequest(device_mojom_UsbDevicePendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceManager_GetDevice_ParamsMojoType, device_mojom_UsbDeviceClientRemote>(
        'deviceClient', 20,
        0,
        mojo.internal.InterfaceProxy(device_mojom_UsbDeviceClientRemote),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface UsbDeviceManager_GetSecurityKeyDevice_ParamsMojoType {
  guid: string;
  deviceReceiver: device_mojom_UsbDevicePendingReceiver;
  deviceClient: (device_mojom_UsbDeviceClientRemote | null);
}


export type UsbDeviceManager_GetSecurityKeyDevice_Params = UsbDeviceManager_GetSecurityKeyDevice_ParamsMojoType;
mojo.internal.Struct<UsbDeviceManager_GetSecurityKeyDevice_ParamsMojoType>(
    UsbDeviceManager_GetSecurityKeyDevice_ParamsSpec.$,
    'UsbDeviceManager_GetSecurityKeyDevice_Params',
    [
      mojo.internal.StructField<UsbDeviceManager_GetSecurityKeyDevice_ParamsMojoType, string>(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceManager_GetSecurityKeyDevice_ParamsMojoType, device_mojom_UsbDevicePendingReceiver>(
        'deviceReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(device_mojom_UsbDevicePendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceManager_GetSecurityKeyDevice_ParamsMojoType, device_mojom_UsbDeviceClientRemote>(
        'deviceClient', 12,
        0,
        mojo.internal.InterfaceProxy(device_mojom_UsbDeviceClientRemote),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface UsbDeviceManager_SetClient_ParamsMojoType {
  client: object;
}


export type UsbDeviceManager_SetClient_Params = UsbDeviceManager_SetClient_ParamsMojoType;
mojo.internal.Struct<UsbDeviceManager_SetClient_ParamsMojoType>(
    UsbDeviceManager_SetClient_ParamsSpec.$,
    'UsbDeviceManager_SetClient_Params',
    [
      mojo.internal.StructField<UsbDeviceManager_SetClient_ParamsMojoType, object>(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(device_mojom_UsbDeviceManagerClientRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



