// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { stringToMojoString16 } from 'chrome://resources/js/mojo_type_util.js';
import { PageCallbackRouter, PageHandlerFactory, PageHandlerRemote } from './tab_search.mojom-webui.js';
/**
 * These values are persisted to logs and should not be renumbered or re-used.
 * See tools/metrics/histograms/enums.xml.
 */
export var RecentlyClosedItemOpenAction;
(function (RecentlyClosedItemOpenAction) {
    RecentlyClosedItemOpenAction[RecentlyClosedItemOpenAction["WITHOUT_SEARCH"] = 0] = "WITHOUT_SEARCH";
    RecentlyClosedItemOpenAction[RecentlyClosedItemOpenAction["WITH_SEARCH"] = 1] = "WITH_SEARCH";
})(RecentlyClosedItemOpenAction || (RecentlyClosedItemOpenAction = {}));
export class TabSearchApiProxyImpl {
    callbackRouter = new PageCallbackRouter();
    handler = new PageHandlerRemote();
    constructor() {
        const factory = PageHandlerFactory.getRemote();
        factory.createPageHandler(this.callbackRouter.$.bindNewPipeAndPassRemote(), this.handler.$.bindNewPipeAndPassReceiver());
    }
    closeTab(tabId) {
        this.handler.closeTab(tabId);
    }
    closeWebUiTab() {
        this.handler.closeWebUiTab();
    }
    declutterTabs(tabIds, urls) {
        this.handler.declutterTabs(tabIds, urls);
    }
    acceptTabOrganization(sessionId, organizationId, tabs) {
        this.handler.acceptTabOrganization(sessionId, organizationId, tabs);
    }
    rejectTabOrganization(sessionId, organizationId) {
        this.handler.rejectTabOrganization(sessionId, organizationId);
    }
    renameTabOrganization(sessionId, organizationId, name) {
        this.handler.renameTabOrganization(sessionId, organizationId, stringToMojoString16(name));
    }
    excludeFromStaleTabs(tabId) {
        this.handler.excludeFromStaleTabs(tabId);
    }
    excludeFromDuplicateTabs(url) {
        this.handler.excludeFromDuplicateTabs(url);
    }
    getProfileData() {
        return this.handler.getProfileData();
    }
    getUnusedTabs() {
        return this.handler.getUnusedTabs();
    }
    getTabSearchSection() {
        return this.handler.getTabSearchSection();
    }
    getTabOrganizationFeature() {
        return this.handler.getTabOrganizationFeature();
    }
    getTabOrganizationSession() {
        return this.handler.getTabOrganizationSession();
    }
    getTabOrganizationModelStrategy() {
        return this.handler.getTabOrganizationModelStrategy();
    }
    getIsSplit() {
        return this.handler.getIsSplit();
    }
    openRecentlyClosedEntry(id, withSearch, isTab, index) {
        chrome.metricsPrivate.recordEnumerationValue(isTab ? 'Tabs.TabSearch.WebUI.RecentlyClosedTabOpenAction' :
            'Tabs.TabSearch.WebUI.RecentlyClosedGroupOpenAction', withSearch ? RecentlyClosedItemOpenAction.WITH_SEARCH :
            RecentlyClosedItemOpenAction.WITHOUT_SEARCH, Object.keys(RecentlyClosedItemOpenAction).length);
        chrome.metricsPrivate.recordSmallCount(withSearch ?
            'Tabs.TabSearch.WebUI.IndexOfOpenRecentlyClosedEntryInFilteredList' :
            'Tabs.TabSearch.WebUI.IndexOfOpenRecentlyClosedEntryInUnfilteredList', index);
        this.handler.openRecentlyClosedEntry(id);
    }
    requestTabOrganization() {
        this.handler.requestTabOrganization();
    }
    rejectSession(sessionId) {
        this.handler.rejectSession(sessionId);
    }
    restartSession() {
        this.handler.restartSession();
    }
    switchToTab(info) {
        this.handler.switchToTab(info);
    }
    getCallbackRouter() {
        return this.callbackRouter;
    }
    removeTabFromOrganization(sessionId, organizationId, tab) {
        this.handler.removeTabFromOrganization(sessionId, organizationId, tab);
    }
    replaceActiveSplitTab(replacementSplitTabId) {
        this.handler.replaceActiveSplitTab(replacementSplitTabId);
    }
    saveRecentlyClosedExpandedPref(expanded) {
        this.handler.saveRecentlyClosedExpandedPref(expanded);
    }
    setOrganizationFeature(feature) {
        this.handler.setOrganizationFeature(feature);
    }
    startTabGroupTutorial() {
        this.handler.startTabGroupTutorial();
    }
    triggerFeedback(sessionId) {
        this.handler.triggerFeedback(sessionId);
    }
    triggerSignIn() {
        this.handler.triggerSignIn();
    }
    openHelpPage() {
        this.handler.openHelpPage();
    }
    setTabOrganizationModelStrategy(strategy) {
        this.handler.setTabOrganizationModelStrategy(strategy);
    }
    setTabOrganizationUserInstruction(userInstruction) {
        this.handler.setTabOrganizationUserInstruction(userInstruction);
    }
    setUserFeedback(sessionId, feedback) {
        this.handler.setUserFeedback(sessionId, feedback);
    }
    notifyOrganizationUiReadyToShow() {
        this.handler.notifyOrganizationUIReadyToShow();
    }
    notifySearchUiReadyToShow() {
        this.handler.notifySearchUIReadyToShow();
    }
    static getInstance() {
        return instance || (instance = new TabSearchApiProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
