/**
 * @fileoverview 'auto-tab-groups-results-actions' is a row with actions that
 * can be taken on an auto tab groups suggestion. It is agnostic as to what
 * that suggestion is, and can be used to suggest one or multiple groups.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import '/strings.m.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
export declare class AutoTabGroupsResultsActionsElement extends CrLitElement {
    static get is(): string;
    static get properties(): {
        multipleOrganizations: {
            type: BooleanConstructor;
        };
        showClear: {
            type: BooleanConstructor;
        };
    };
    accessor multipleOrganizations: boolean;
    accessor showClear: boolean;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    protected getCreateButtonText_(): string;
    protected onClearClick_(): void;
    protected onCreateGroupClick_(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'auto-tab-groups-results-actions': AutoTabGroupsResultsActionsElement;
    }
}
