// chrome/browser/ui/webui/tab_search/tab_search.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ColorSpec as tabGroups_mojom_ColorSpec,
  Color as tabGroups_mojom_Color
} from './tab_group_types.mojom-webui.js';
import {
  TabAlertStateSpec as tabs_mojom_TabAlertStateSpec,
  TabAlertState as tabs_mojom_TabAlertState
} from './tabs.mojom-webui.js';
import {
  String16Spec as mojoBase_mojom_String16Spec,
  String16 as mojoBase_mojom_String16
} from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec,
  TimeTicks as mojoBase_mojom_TimeTicks
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  TokenSpec as mojoBase_mojom_TokenSpec,
  Token as mojoBase_mojom_Token
} from '//resources/mojo/mojo/public/mojom/base/token.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const DeclutterCTREventSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum DeclutterCTREvent {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kDeclutterShown = 0,
  kCloseTabsClicked = 1,
}

export const SelectorCTREventSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SelectorCTREvent {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kSelectorShown = 0,
  kAutoTabGroupsClicked = 1,
  kDeclutterClicked = 2,
}

export const TabDeclutterEntryPointSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum TabDeclutterEntryPoint {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kNudge = 0,
  kAppMenu = 1,
  kSelector = 2,
}

export const TabOrganizationStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum TabOrganizationState {

  MIN_VALUE = 0,
  MAX_VALUE = 4,
  kInitializing = 0,
  kNotStarted = 1,
  kInProgress = 2,
  kSuccess = 3,
  kFailure = 4,
}

export const TabOrganizationFeatureSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum TabOrganizationFeature {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kNone = 0,
  kSelector = 1,
  kAutoTabGroups = 2,
  kDeclutter = 3,
}

export const TabOrganizationErrorSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum TabOrganizationError {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kNone = 0,
  kGrouping = 1,
  kGeneric = 2,
}

export const TabOrganizationModelStrategySpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum TabOrganizationModelStrategy {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kTopic = 0,
  kTask = 1,
  kDomain = 2,
}

export const TabSearchSectionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum TabSearchSection {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kNone = 0,
  kSearch = 1,
  kOrganize = 2,
}

export const UserFeedbackSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UserFeedback {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUserFeedBackUnspecified = 0,
  kUserFeedBackPositive = 1,
  kUserFeedBackNegative = 2,
}



export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'tab_search.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "tab_search.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'tab_search.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  closeTab(tabId: number): void;
  closeWebUiTab(): void;
  declutterTabs(tabIds: number[], urls: url_mojom_Url[]): void;
  acceptTabOrganization(sessionId: number, organizationId: number, tabs: Tab[]): void;
  rejectTabOrganization(sessionId: number, organizationId: number): void;
  renameTabOrganization(sessionId: number, organizationId: number, name: mojoBase_mojom_String16): void;
  excludeFromStaleTabs(tabId: number): void;
  excludeFromDuplicateTabs(url: url_mojom_Url): void;
  getProfileData(): Promise<{
        profileData: ProfileData, }>;
  getUnusedTabs(): Promise<{
        tabs: UnusedTabInfo, }>;
  getTabSearchSection(): Promise<{
        section: TabSearchSection, }>;
  getTabOrganizationFeature(): Promise<{
        feature: TabOrganizationFeature, }>;
  getTabOrganizationSession(): Promise<{
        session: TabOrganizationSession, }>;
  getTabOrganizationModelStrategy(): Promise<{
        strategy: TabOrganizationModelStrategy, }>;
  getIsSplit(): Promise<{
        isSplit: boolean, }>;
  switchToTab(switchToTabInfo: SwitchToTabInfo): void;
  openRecentlyClosedEntry(sessionId: number): void;
  requestTabOrganization(): void;
  removeTabFromOrganization(sessionId: number, organizationId: number, tab: Tab): void;
  rejectSession(sessionId: number): void;
  replaceActiveSplitTab(replacementTabId: number): void;
  restartSession(): void;
  saveRecentlyClosedExpandedPref(expanded: boolean): void;
  setOrganizationFeature(feature: TabOrganizationFeature): void;
  startTabGroupTutorial(): void;
  triggerFeedback(sessionId: number): void;
  triggerSignIn(): void;
  openHelpPage(): void;
  setTabOrganizationModelStrategy(strategy: TabOrganizationModelStrategy): void;
  setTabOrganizationUserInstruction(userInstruction: string): void;
  setUserFeedback(sessionId: number, feedback: UserFeedback): void;
  notifyOrganizationUIReadyToShow(): void;
  notifySearchUIReadyToShow(): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  closeTab(
      tabId: number): void {
    this.proxy.sendMessage(
        0,
        PageHandler_CloseTab_ParamsSpec.$,
        null,
        [
          tabId
        ],
        false);
  }

  closeWebUiTab(): void {
    this.proxy.sendMessage(
        1,
        PageHandler_CloseWebUiTab_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  declutterTabs(
      tabIds: number[],
      urls: url_mojom_Url[]): void {
    this.proxy.sendMessage(
        2,
        PageHandler_DeclutterTabs_ParamsSpec.$,
        null,
        [
          tabIds,
          urls
        ],
        false);
  }

  acceptTabOrganization(
      sessionId: number,
      organizationId: number,
      tabs: Tab[]): void {
    this.proxy.sendMessage(
        3,
        PageHandler_AcceptTabOrganization_ParamsSpec.$,
        null,
        [
          sessionId,
          organizationId,
          tabs
        ],
        false);
  }

  rejectTabOrganization(
      sessionId: number,
      organizationId: number): void {
    this.proxy.sendMessage(
        4,
        PageHandler_RejectTabOrganization_ParamsSpec.$,
        null,
        [
          sessionId,
          organizationId
        ],
        false);
  }

  renameTabOrganization(
      sessionId: number,
      organizationId: number,
      name: mojoBase_mojom_String16): void {
    this.proxy.sendMessage(
        5,
        PageHandler_RenameTabOrganization_ParamsSpec.$,
        null,
        [
          sessionId,
          organizationId,
          name
        ],
        false);
  }

  excludeFromStaleTabs(
      tabId: number): void {
    this.proxy.sendMessage(
        6,
        PageHandler_ExcludeFromStaleTabs_ParamsSpec.$,
        null,
        [
          tabId
        ],
        false);
  }

  excludeFromDuplicateTabs(
      url: url_mojom_Url): void {
    this.proxy.sendMessage(
        7,
        PageHandler_ExcludeFromDuplicateTabs_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  getProfileData(): Promise<{
        profileData: ProfileData, }> {
    return this.proxy.sendMessage(
        8,
        PageHandler_GetProfileData_ParamsSpec.$,
        PageHandler_GetProfileData_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getUnusedTabs(): Promise<{
        tabs: UnusedTabInfo, }> {
    return this.proxy.sendMessage(
        9,
        PageHandler_GetUnusedTabs_ParamsSpec.$,
        PageHandler_GetUnusedTabs_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getTabSearchSection(): Promise<{
        section: TabSearchSection, }> {
    return this.proxy.sendMessage(
        10,
        PageHandler_GetTabSearchSection_ParamsSpec.$,
        PageHandler_GetTabSearchSection_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getTabOrganizationFeature(): Promise<{
        feature: TabOrganizationFeature, }> {
    return this.proxy.sendMessage(
        11,
        PageHandler_GetTabOrganizationFeature_ParamsSpec.$,
        PageHandler_GetTabOrganizationFeature_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getTabOrganizationSession(): Promise<{
        session: TabOrganizationSession, }> {
    return this.proxy.sendMessage(
        12,
        PageHandler_GetTabOrganizationSession_ParamsSpec.$,
        PageHandler_GetTabOrganizationSession_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getTabOrganizationModelStrategy(): Promise<{
        strategy: TabOrganizationModelStrategy, }> {
    return this.proxy.sendMessage(
        13,
        PageHandler_GetTabOrganizationModelStrategy_ParamsSpec.$,
        PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getIsSplit(): Promise<{
        isSplit: boolean, }> {
    return this.proxy.sendMessage(
        14,
        PageHandler_GetIsSplit_ParamsSpec.$,
        PageHandler_GetIsSplit_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  switchToTab(
      switchToTabInfo: SwitchToTabInfo): void {
    this.proxy.sendMessage(
        15,
        PageHandler_SwitchToTab_ParamsSpec.$,
        null,
        [
          switchToTabInfo
        ],
        false);
  }

  openRecentlyClosedEntry(
      sessionId: number): void {
    this.proxy.sendMessage(
        16,
        PageHandler_OpenRecentlyClosedEntry_ParamsSpec.$,
        null,
        [
          sessionId
        ],
        false);
  }

  requestTabOrganization(): void {
    this.proxy.sendMessage(
        17,
        PageHandler_RequestTabOrganization_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  removeTabFromOrganization(
      sessionId: number,
      organizationId: number,
      tab: Tab): void {
    this.proxy.sendMessage(
        18,
        PageHandler_RemoveTabFromOrganization_ParamsSpec.$,
        null,
        [
          sessionId,
          organizationId,
          tab
        ],
        false);
  }

  rejectSession(
      sessionId: number): void {
    this.proxy.sendMessage(
        19,
        PageHandler_RejectSession_ParamsSpec.$,
        null,
        [
          sessionId
        ],
        false);
  }

  replaceActiveSplitTab(
      replacementTabId: number): void {
    this.proxy.sendMessage(
        20,
        PageHandler_ReplaceActiveSplitTab_ParamsSpec.$,
        null,
        [
          replacementTabId
        ],
        false);
  }

  restartSession(): void {
    this.proxy.sendMessage(
        21,
        PageHandler_RestartSession_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  saveRecentlyClosedExpandedPref(
      expanded: boolean): void {
    this.proxy.sendMessage(
        22,
        PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec.$,
        null,
        [
          expanded
        ],
        false);
  }

  setOrganizationFeature(
      feature: TabOrganizationFeature): void {
    this.proxy.sendMessage(
        23,
        PageHandler_SetOrganizationFeature_ParamsSpec.$,
        null,
        [
          feature
        ],
        false);
  }

  startTabGroupTutorial(): void {
    this.proxy.sendMessage(
        24,
        PageHandler_StartTabGroupTutorial_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  triggerFeedback(
      sessionId: number): void {
    this.proxy.sendMessage(
        25,
        PageHandler_TriggerFeedback_ParamsSpec.$,
        null,
        [
          sessionId
        ],
        false);
  }

  triggerSignIn(): void {
    this.proxy.sendMessage(
        26,
        PageHandler_TriggerSignIn_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openHelpPage(): void {
    this.proxy.sendMessage(
        27,
        PageHandler_OpenHelpPage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setTabOrganizationModelStrategy(
      strategy: TabOrganizationModelStrategy): void {
    this.proxy.sendMessage(
        28,
        PageHandler_SetTabOrganizationModelStrategy_ParamsSpec.$,
        null,
        [
          strategy
        ],
        false);
  }

  setTabOrganizationUserInstruction(
      userInstruction: string): void {
    this.proxy.sendMessage(
        29,
        PageHandler_SetTabOrganizationUserInstruction_ParamsSpec.$,
        null,
        [
          userInstruction
        ],
        false);
  }

  setUserFeedback(
      sessionId: number,
      feedback: UserFeedback): void {
    this.proxy.sendMessage(
        30,
        PageHandler_SetUserFeedback_ParamsSpec.$,
        null,
        [
          sessionId,
          feedback
        ],
        false);
  }

  notifyOrganizationUIReadyToShow(): void {
    this.proxy.sendMessage(
        31,
        PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  notifySearchUIReadyToShow(): void {
    this.proxy.sendMessage(
        32,
        PageHandler_NotifySearchUIReadyToShow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_CloseTab_ParamsSpec.$,
        null,
        impl.closeTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_CloseWebUiTab_ParamsSpec.$,
        null,
        impl.closeWebUiTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_DeclutterTabs_ParamsSpec.$,
        null,
        impl.declutterTabs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_AcceptTabOrganization_ParamsSpec.$,
        null,
        impl.acceptTabOrganization.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_RejectTabOrganization_ParamsSpec.$,
        null,
        impl.rejectTabOrganization.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_RenameTabOrganization_ParamsSpec.$,
        null,
        impl.renameTabOrganization.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_ExcludeFromStaleTabs_ParamsSpec.$,
        null,
        impl.excludeFromStaleTabs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_ExcludeFromDuplicateTabs_ParamsSpec.$,
        null,
        impl.excludeFromDuplicateTabs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_GetProfileData_ParamsSpec.$,
        PageHandler_GetProfileData_ResponseParamsSpec.$,
        impl.getProfileData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_GetUnusedTabs_ParamsSpec.$,
        PageHandler_GetUnusedTabs_ResponseParamsSpec.$,
        impl.getUnusedTabs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageHandler_GetTabSearchSection_ParamsSpec.$,
        PageHandler_GetTabSearchSection_ResponseParamsSpec.$,
        impl.getTabSearchSection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PageHandler_GetTabOrganizationFeature_ParamsSpec.$,
        PageHandler_GetTabOrganizationFeature_ResponseParamsSpec.$,
        impl.getTabOrganizationFeature.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        PageHandler_GetTabOrganizationSession_ParamsSpec.$,
        PageHandler_GetTabOrganizationSession_ResponseParamsSpec.$,
        impl.getTabOrganizationSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        PageHandler_GetTabOrganizationModelStrategy_ParamsSpec.$,
        PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec.$,
        impl.getTabOrganizationModelStrategy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        PageHandler_GetIsSplit_ParamsSpec.$,
        PageHandler_GetIsSplit_ResponseParamsSpec.$,
        impl.getIsSplit.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        PageHandler_SwitchToTab_ParamsSpec.$,
        null,
        impl.switchToTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        PageHandler_OpenRecentlyClosedEntry_ParamsSpec.$,
        null,
        impl.openRecentlyClosedEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        PageHandler_RequestTabOrganization_ParamsSpec.$,
        null,
        impl.requestTabOrganization.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        PageHandler_RemoveTabFromOrganization_ParamsSpec.$,
        null,
        impl.removeTabFromOrganization.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        PageHandler_RejectSession_ParamsSpec.$,
        null,
        impl.rejectSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        PageHandler_ReplaceActiveSplitTab_ParamsSpec.$,
        null,
        impl.replaceActiveSplitTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        PageHandler_RestartSession_ParamsSpec.$,
        null,
        impl.restartSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec.$,
        null,
        impl.saveRecentlyClosedExpandedPref.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        PageHandler_SetOrganizationFeature_ParamsSpec.$,
        null,
        impl.setOrganizationFeature.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        PageHandler_StartTabGroupTutorial_ParamsSpec.$,
        null,
        impl.startTabGroupTutorial.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        PageHandler_TriggerFeedback_ParamsSpec.$,
        null,
        impl.triggerFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        PageHandler_TriggerSignIn_ParamsSpec.$,
        null,
        impl.triggerSignIn.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        PageHandler_OpenHelpPage_ParamsSpec.$,
        null,
        impl.openHelpPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        PageHandler_SetTabOrganizationModelStrategy_ParamsSpec.$,
        null,
        impl.setTabOrganizationModelStrategy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        PageHandler_SetTabOrganizationUserInstruction_ParamsSpec.$,
        null,
        impl.setTabOrganizationUserInstruction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        PageHandler_SetUserFeedback_ParamsSpec.$,
        null,
        impl.setUserFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec.$,
        null,
        impl.notifyOrganizationUIReadyToShow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        32,
        PageHandler_NotifySearchUIReadyToShow_ParamsSpec.$,
        null,
        impl.notifySearchUIReadyToShow.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "tab_search.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  closeTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closeWebUiTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  declutterTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  acceptTabOrganization: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  rejectTabOrganization: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  renameTabOrganization: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  excludeFromStaleTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  excludeFromDuplicateTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getProfileData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getUnusedTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getTabSearchSection: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getTabOrganizationFeature: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getTabOrganizationSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getTabOrganizationModelStrategy: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getIsSplit: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  switchToTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openRecentlyClosedEntry: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestTabOrganization: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeTabFromOrganization: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  rejectSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  replaceActiveSplitTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  restartSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  saveRecentlyClosedExpandedPref: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setOrganizationFeature: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  startTabGroupTutorial: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  triggerFeedback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  triggerSignIn: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openHelpPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setTabOrganizationModelStrategy: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setTabOrganizationUserInstruction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setUserFeedback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyOrganizationUIReadyToShow: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifySearchUIReadyToShow: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.closeTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_CloseTab_ParamsSpec.$,
        null,
        this.closeTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.closeWebUiTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_CloseWebUiTab_ParamsSpec.$,
        null,
        this.closeWebUiTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.declutterTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_DeclutterTabs_ParamsSpec.$,
        null,
        this.declutterTabs.createReceiverHandler(false /* expectsResponse */),
        false);
    this.acceptTabOrganization =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_AcceptTabOrganization_ParamsSpec.$,
        null,
        this.acceptTabOrganization.createReceiverHandler(false /* expectsResponse */),
        false);
    this.rejectTabOrganization =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_RejectTabOrganization_ParamsSpec.$,
        null,
        this.rejectTabOrganization.createReceiverHandler(false /* expectsResponse */),
        false);
    this.renameTabOrganization =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_RenameTabOrganization_ParamsSpec.$,
        null,
        this.renameTabOrganization.createReceiverHandler(false /* expectsResponse */),
        false);
    this.excludeFromStaleTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_ExcludeFromStaleTabs_ParamsSpec.$,
        null,
        this.excludeFromStaleTabs.createReceiverHandler(false /* expectsResponse */),
        false);
    this.excludeFromDuplicateTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_ExcludeFromDuplicateTabs_ParamsSpec.$,
        null,
        this.excludeFromDuplicateTabs.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getProfileData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_GetProfileData_ParamsSpec.$,
        PageHandler_GetProfileData_ResponseParamsSpec.$,
        this.getProfileData.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getUnusedTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_GetUnusedTabs_ParamsSpec.$,
        PageHandler_GetUnusedTabs_ResponseParamsSpec.$,
        this.getUnusedTabs.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getTabSearchSection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageHandler_GetTabSearchSection_ParamsSpec.$,
        PageHandler_GetTabSearchSection_ResponseParamsSpec.$,
        this.getTabSearchSection.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getTabOrganizationFeature =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PageHandler_GetTabOrganizationFeature_ParamsSpec.$,
        PageHandler_GetTabOrganizationFeature_ResponseParamsSpec.$,
        this.getTabOrganizationFeature.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getTabOrganizationSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        PageHandler_GetTabOrganizationSession_ParamsSpec.$,
        PageHandler_GetTabOrganizationSession_ResponseParamsSpec.$,
        this.getTabOrganizationSession.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getTabOrganizationModelStrategy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        PageHandler_GetTabOrganizationModelStrategy_ParamsSpec.$,
        PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec.$,
        this.getTabOrganizationModelStrategy.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getIsSplit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        PageHandler_GetIsSplit_ParamsSpec.$,
        PageHandler_GetIsSplit_ResponseParamsSpec.$,
        this.getIsSplit.createReceiverHandler(true /* expectsResponse */),
        false);
    this.switchToTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        PageHandler_SwitchToTab_ParamsSpec.$,
        null,
        this.switchToTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openRecentlyClosedEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        PageHandler_OpenRecentlyClosedEntry_ParamsSpec.$,
        null,
        this.openRecentlyClosedEntry.createReceiverHandler(false /* expectsResponse */),
        false);
    this.requestTabOrganization =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        PageHandler_RequestTabOrganization_ParamsSpec.$,
        null,
        this.requestTabOrganization.createReceiverHandler(false /* expectsResponse */),
        false);
    this.removeTabFromOrganization =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        PageHandler_RemoveTabFromOrganization_ParamsSpec.$,
        null,
        this.removeTabFromOrganization.createReceiverHandler(false /* expectsResponse */),
        false);
    this.rejectSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        PageHandler_RejectSession_ParamsSpec.$,
        null,
        this.rejectSession.createReceiverHandler(false /* expectsResponse */),
        false);
    this.replaceActiveSplitTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        PageHandler_ReplaceActiveSplitTab_ParamsSpec.$,
        null,
        this.replaceActiveSplitTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.restartSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        PageHandler_RestartSession_ParamsSpec.$,
        null,
        this.restartSession.createReceiverHandler(false /* expectsResponse */),
        false);
    this.saveRecentlyClosedExpandedPref =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec.$,
        null,
        this.saveRecentlyClosedExpandedPref.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setOrganizationFeature =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        PageHandler_SetOrganizationFeature_ParamsSpec.$,
        null,
        this.setOrganizationFeature.createReceiverHandler(false /* expectsResponse */),
        false);
    this.startTabGroupTutorial =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        PageHandler_StartTabGroupTutorial_ParamsSpec.$,
        null,
        this.startTabGroupTutorial.createReceiverHandler(false /* expectsResponse */),
        false);
    this.triggerFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        PageHandler_TriggerFeedback_ParamsSpec.$,
        null,
        this.triggerFeedback.createReceiverHandler(false /* expectsResponse */),
        false);
    this.triggerSignIn =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        PageHandler_TriggerSignIn_ParamsSpec.$,
        null,
        this.triggerSignIn.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openHelpPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        PageHandler_OpenHelpPage_ParamsSpec.$,
        null,
        this.openHelpPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setTabOrganizationModelStrategy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        PageHandler_SetTabOrganizationModelStrategy_ParamsSpec.$,
        null,
        this.setTabOrganizationModelStrategy.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setTabOrganizationUserInstruction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        PageHandler_SetTabOrganizationUserInstruction_ParamsSpec.$,
        null,
        this.setTabOrganizationUserInstruction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setUserFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        PageHandler_SetUserFeedback_ParamsSpec.$,
        null,
        this.setUserFeedback.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyOrganizationUIReadyToShow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec.$,
        null,
        this.notifyOrganizationUIReadyToShow.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifySearchUIReadyToShow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        32,
        PageHandler_NotifySearchUIReadyToShow_ParamsSpec.$,
        null,
        this.notifySearchUIReadyToShow.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'tab_search.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  tabOrganizationSessionUpdated(session: TabOrganizationSession): void;
  tabOrganizationModelStrategyUpdated(strategy: TabOrganizationModelStrategy): void;
  hostWindowChanged(): void;
  tabsChanged(profileTabs: ProfileData): void;
  tabUpdated(tabUpdateInfo: TabUpdateInfo): void;
  tabsRemoved(tabsRemovedInfo: TabsRemovedInfo): void;
  tabSearchSectionChanged(section: TabSearchSection): void;
  tabOrganizationFeatureChanged(feature: TabOrganizationFeature): void;
  showFREChanged(show: boolean): void;
  tabOrganizationEnabledChanged(enabled: boolean): void;
  unusedTabsChanged(tabs: UnusedTabInfo): void;
  tabUnsplit(): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  tabOrganizationSessionUpdated(
      session: TabOrganizationSession): void {
    this.proxy.sendMessage(
        0,
        Page_TabOrganizationSessionUpdated_ParamsSpec.$,
        null,
        [
          session
        ],
        false);
  }

  tabOrganizationModelStrategyUpdated(
      strategy: TabOrganizationModelStrategy): void {
    this.proxy.sendMessage(
        1,
        Page_TabOrganizationModelStrategyUpdated_ParamsSpec.$,
        null,
        [
          strategy
        ],
        false);
  }

  hostWindowChanged(): void {
    this.proxy.sendMessage(
        2,
        Page_HostWindowChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  tabsChanged(
      profileTabs: ProfileData): void {
    this.proxy.sendMessage(
        3,
        Page_TabsChanged_ParamsSpec.$,
        null,
        [
          profileTabs
        ],
        false);
  }

  tabUpdated(
      tabUpdateInfo: TabUpdateInfo): void {
    this.proxy.sendMessage(
        4,
        Page_TabUpdated_ParamsSpec.$,
        null,
        [
          tabUpdateInfo
        ],
        false);
  }

  tabsRemoved(
      tabsRemovedInfo: TabsRemovedInfo): void {
    this.proxy.sendMessage(
        5,
        Page_TabsRemoved_ParamsSpec.$,
        null,
        [
          tabsRemovedInfo
        ],
        false);
  }

  tabSearchSectionChanged(
      section: TabSearchSection): void {
    this.proxy.sendMessage(
        6,
        Page_TabSearchSectionChanged_ParamsSpec.$,
        null,
        [
          section
        ],
        false);
  }

  tabOrganizationFeatureChanged(
      feature: TabOrganizationFeature): void {
    this.proxy.sendMessage(
        7,
        Page_TabOrganizationFeatureChanged_ParamsSpec.$,
        null,
        [
          feature
        ],
        false);
  }

  showFREChanged(
      show: boolean): void {
    this.proxy.sendMessage(
        8,
        Page_ShowFREChanged_ParamsSpec.$,
        null,
        [
          show
        ],
        false);
  }

  tabOrganizationEnabledChanged(
      enabled: boolean): void {
    this.proxy.sendMessage(
        9,
        Page_TabOrganizationEnabledChanged_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  unusedTabsChanged(
      tabs: UnusedTabInfo): void {
    this.proxy.sendMessage(
        10,
        Page_UnusedTabsChanged_ParamsSpec.$,
        null,
        [
          tabs
        ],
        false);
  }

  tabUnsplit(): void {
    this.proxy.sendMessage(
        11,
        Page_TabUnsplit_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_TabOrganizationSessionUpdated_ParamsSpec.$,
        null,
        impl.tabOrganizationSessionUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_TabOrganizationModelStrategyUpdated_ParamsSpec.$,
        null,
        impl.tabOrganizationModelStrategyUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_HostWindowChanged_ParamsSpec.$,
        null,
        impl.hostWindowChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Page_TabsChanged_ParamsSpec.$,
        null,
        impl.tabsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Page_TabUpdated_ParamsSpec.$,
        null,
        impl.tabUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Page_TabsRemoved_ParamsSpec.$,
        null,
        impl.tabsRemoved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Page_TabSearchSectionChanged_ParamsSpec.$,
        null,
        impl.tabSearchSectionChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Page_TabOrganizationFeatureChanged_ParamsSpec.$,
        null,
        impl.tabOrganizationFeatureChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        Page_ShowFREChanged_ParamsSpec.$,
        null,
        impl.showFREChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        Page_TabOrganizationEnabledChanged_ParamsSpec.$,
        null,
        impl.tabOrganizationEnabledChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        Page_UnusedTabsChanged_ParamsSpec.$,
        null,
        impl.unusedTabsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        Page_TabUnsplit_ParamsSpec.$,
        null,
        impl.tabUnsplit.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "tab_search.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  tabOrganizationSessionUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  tabOrganizationModelStrategyUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  hostWindowChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  tabsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  tabUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  tabsRemoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  tabSearchSectionChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  tabOrganizationFeatureChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showFREChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  tabOrganizationEnabledChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  unusedTabsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  tabUnsplit: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.tabOrganizationSessionUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_TabOrganizationSessionUpdated_ParamsSpec.$,
        null,
        this.tabOrganizationSessionUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.tabOrganizationModelStrategyUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_TabOrganizationModelStrategyUpdated_ParamsSpec.$,
        null,
        this.tabOrganizationModelStrategyUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.hostWindowChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_HostWindowChanged_ParamsSpec.$,
        null,
        this.hostWindowChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.tabsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Page_TabsChanged_ParamsSpec.$,
        null,
        this.tabsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.tabUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Page_TabUpdated_ParamsSpec.$,
        null,
        this.tabUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.tabsRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Page_TabsRemoved_ParamsSpec.$,
        null,
        this.tabsRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    this.tabSearchSectionChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Page_TabSearchSectionChanged_ParamsSpec.$,
        null,
        this.tabSearchSectionChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.tabOrganizationFeatureChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Page_TabOrganizationFeatureChanged_ParamsSpec.$,
        null,
        this.tabOrganizationFeatureChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showFREChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        Page_ShowFREChanged_ParamsSpec.$,
        null,
        this.showFREChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.tabOrganizationEnabledChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        Page_TabOrganizationEnabledChanged_ParamsSpec.$,
        null,
        this.tabOrganizationEnabledChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.unusedTabsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        Page_UnusedTabsChanged_ParamsSpec.$,
        null,
        this.unusedTabsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.tabUnsplit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        Page_TabUnsplit_ParamsSpec.$,
        null,
        this.tabUnsplit.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ProfileDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WindowSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const RecentlyClosedTabSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabGroupSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const RecentlyClosedTabGroupSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SwitchToTabInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabOrganizationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabOrganizationSessionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabUpdateInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabsRemovedInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UnusedTabInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CloseTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CloseWebUiTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DeclutterTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_AcceptTabOrganization_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RejectTabOrganization_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RenameTabOrganization_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ExcludeFromStaleTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ExcludeFromDuplicateTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetProfileData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetProfileData_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetUnusedTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetUnusedTabs_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabSearchSection_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabSearchSection_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabOrganizationFeature_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabOrganizationFeature_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabOrganizationSession_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabOrganizationSession_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabOrganizationModelStrategy_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetIsSplit_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetIsSplit_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SwitchToTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenRecentlyClosedEntry_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RequestTabOrganization_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RemoveTabFromOrganization_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RejectSession_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ReplaceActiveSplitTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RestartSession_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetOrganizationFeature_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_StartTabGroupTutorial_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_TriggerFeedback_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_TriggerSignIn_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenHelpPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetTabOrganizationModelStrategy_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetTabOrganizationUserInstruction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetUserFeedback_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_NotifySearchUIReadyToShow_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_TabOrganizationSessionUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_TabOrganizationModelStrategyUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_HostWindowChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_TabsChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_TabUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_TabsRemoved_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_TabSearchSectionChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_TabOrganizationFeatureChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ShowFREChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_TabOrganizationEnabledChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_UnusedTabsChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_TabUnsplit_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ProfileDataMojoType {
  windows: Window[];
  tabGroups: TabGroup[];
  recentlyClosedTabs: RecentlyClosedTab[];
  recentlyClosedTabGroups: RecentlyClosedTabGroup[];
  recentlyClosedSectionExpanded: boolean;
}


export type ProfileData = ProfileDataMojoType;
mojo.internal.Struct<ProfileDataMojoType>(
    ProfileDataSpec.$,
    'ProfileData',
    [
      mojo.internal.StructField<ProfileDataMojoType, Window[]>(
        'windows', 0,
        0,
        mojo.internal.Array(WindowSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProfileDataMojoType, TabGroup[]>(
        'tabGroups', 8,
        0,
        mojo.internal.Array(TabGroupSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProfileDataMojoType, RecentlyClosedTab[]>(
        'recentlyClosedTabs', 16,
        0,
        mojo.internal.Array(RecentlyClosedTabSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProfileDataMojoType, RecentlyClosedTabGroup[]>(
        'recentlyClosedTabGroups', 24,
        0,
        mojo.internal.Array(RecentlyClosedTabGroupSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProfileDataMojoType, boolean>(
        'recentlyClosedSectionExpanded', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface WindowMojoType {
  active: boolean;
  isHostWindow: boolean;
  height: number;
  tabs: Tab[];
}


export type Window = WindowMojoType;
mojo.internal.Struct<WindowMojoType>(
    WindowSpec.$,
    'Window',
    [
      mojo.internal.StructField<WindowMojoType, boolean>(
        'active', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WindowMojoType, boolean>(
        'isHostWindow', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WindowMojoType, number>(
        'height', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WindowMojoType, Tab[]>(
        'tabs', 8,
        0,
        mojo.internal.Array(TabSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabMojoType {
  active: boolean;
  visible: boolean;
  pinned: boolean;
  split: boolean;
  isDefaultFavicon: boolean;
  showIcon: boolean;
  index: number;
  alertStates: tabs_mojom_TabAlertState[];
  tabId: number;
  groupId: (mojoBase_mojom_Token | null);
  title: string;
  url: url_mojom_Url;
  faviconUrl: (url_mojom_Url | null);
  lastActiveTimeTicks: mojoBase_mojom_TimeTicks;
  lastActiveElapsedText: string;
}


export type Tab = TabMojoType;
mojo.internal.Struct<TabMojoType>(
    TabSpec.$,
    'Tab',
    [
      mojo.internal.StructField<TabMojoType, boolean>(
        'active', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, boolean>(
        'visible', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, tabs_mojom_TabAlertState[]>(
        'alertStates', 8,
        0,
        mojo.internal.Array(tabs_mojom_TabAlertStateSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, number>(
        'index', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, number>(
        'tabId', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, mojoBase_mojom_Token>(
        'groupId', 24,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, boolean>(
        'pinned', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, boolean>(
        'split', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, string>(
        'title', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, url_mojom_Url>(
        'url', 40,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, url_mojom_Url>(
        'faviconUrl', 48,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, boolean>(
        'isDefaultFavicon', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, boolean>(
        'showIcon', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, mojoBase_mojom_TimeTicks>(
        'lastActiveTimeTicks', 56,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, string>(
        'lastActiveElapsedText', 64,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 80],]);





export interface RecentlyClosedTabMojoType {
  tabId: number;
  groupId: (mojoBase_mojom_Token | null);
  title: string;
  url: url_mojom_Url;
  lastActiveTime: mojoBase_mojom_Time;
  lastActiveElapsedText: string;
}


export type RecentlyClosedTab = RecentlyClosedTabMojoType;
mojo.internal.Struct<RecentlyClosedTabMojoType>(
    RecentlyClosedTabSpec.$,
    'RecentlyClosedTab',
    [
      mojo.internal.StructField<RecentlyClosedTabMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RecentlyClosedTabMojoType, mojoBase_mojom_Token>(
        'groupId', 8,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RecentlyClosedTabMojoType, string>(
        'title', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RecentlyClosedTabMojoType, url_mojom_Url>(
        'url', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RecentlyClosedTabMojoType, mojoBase_mojom_Time>(
        'lastActiveTime', 32,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RecentlyClosedTabMojoType, string>(
        'lastActiveElapsedText', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface TabGroupMojoType {
  id: mojoBase_mojom_Token;
  color: tabGroups_mojom_Color;
  title: string;
}


export type TabGroup = TabGroupMojoType;
mojo.internal.Struct<TabGroupMojoType>(
    TabGroupSpec.$,
    'TabGroup',
    [
      mojo.internal.StructField<TabGroupMojoType, mojoBase_mojom_Token>(
        'id', 0,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupMojoType, tabGroups_mojom_Color>(
        'color', 8,
        0,
        tabGroups_mojom_ColorSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabGroupMojoType, string>(
        'title', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface RecentlyClosedTabGroupMojoType {
  sessionId: number;
  color: tabGroups_mojom_Color;
  id: mojoBase_mojom_Token;
  title: string;
  tabCount: number;
  lastActiveTime: mojoBase_mojom_Time;
  lastActiveElapsedText: string;
}


export type RecentlyClosedTabGroup = RecentlyClosedTabGroupMojoType;
mojo.internal.Struct<RecentlyClosedTabGroupMojoType>(
    RecentlyClosedTabGroupSpec.$,
    'RecentlyClosedTabGroup',
    [
      mojo.internal.StructField<RecentlyClosedTabGroupMojoType, number>(
        'sessionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RecentlyClosedTabGroupMojoType, mojoBase_mojom_Token>(
        'id', 8,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RecentlyClosedTabGroupMojoType, tabGroups_mojom_Color>(
        'color', 4,
        0,
        tabGroups_mojom_ColorSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RecentlyClosedTabGroupMojoType, string>(
        'title', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RecentlyClosedTabGroupMojoType, number>(
        'tabCount', 24,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RecentlyClosedTabGroupMojoType, mojoBase_mojom_Time>(
        'lastActiveTime', 32,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RecentlyClosedTabGroupMojoType, string>(
        'lastActiveElapsedText', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface SwitchToTabInfoMojoType {
  tabId: number;
}


export type SwitchToTabInfo = SwitchToTabInfoMojoType;
mojo.internal.Struct<SwitchToTabInfoMojoType>(
    SwitchToTabInfoSpec.$,
    'SwitchToTabInfo',
    [
      mojo.internal.StructField<SwitchToTabInfoMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TabOrganizationMojoType {
  organizationId: number;
  firstNewTabIndex: number;
  tabs: Tab[];
  name: mojoBase_mojom_String16;
}


export type TabOrganization = TabOrganizationMojoType;
mojo.internal.Struct<TabOrganizationMojoType>(
    TabOrganizationSpec.$,
    'TabOrganization',
    [
      mojo.internal.StructField<TabOrganizationMojoType, number>(
        'organizationId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabOrganizationMojoType, Tab[]>(
        'tabs', 8,
        0,
        mojo.internal.Array(TabSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabOrganizationMojoType, number>(
        'firstNewTabIndex', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabOrganizationMojoType, mojoBase_mojom_String16>(
        'name', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface TabOrganizationSessionMojoType {
  sessionId: number;
  state: TabOrganizationState;
  organizations: TabOrganization[];
  error: TabOrganizationError;
  activeTabId: number;
}


export type TabOrganizationSession = TabOrganizationSessionMojoType;
mojo.internal.Struct<TabOrganizationSessionMojoType>(
    TabOrganizationSessionSpec.$,
    'TabOrganizationSession',
    [
      mojo.internal.StructField<TabOrganizationSessionMojoType, number>(
        'sessionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabOrganizationSessionMojoType, TabOrganizationState>(
        'state', 4,
        0,
        TabOrganizationStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabOrganizationSessionMojoType, TabOrganization[]>(
        'organizations', 8,
        0,
        mojo.internal.Array(TabOrganizationSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabOrganizationSessionMojoType, TabOrganizationError>(
        'error', 16,
        0,
        TabOrganizationErrorSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabOrganizationSessionMojoType, number>(
        'activeTabId', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface TabUpdateInfoMojoType {
  inActiveWindow: boolean;
  inHostWindow: boolean;
  tab: Tab;
}


export type TabUpdateInfo = TabUpdateInfoMojoType;
mojo.internal.Struct<TabUpdateInfoMojoType>(
    TabUpdateInfoSpec.$,
    'TabUpdateInfo',
    [
      mojo.internal.StructField<TabUpdateInfoMojoType, boolean>(
        'inActiveWindow', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabUpdateInfoMojoType, boolean>(
        'inHostWindow', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabUpdateInfoMojoType, Tab>(
        'tab', 8,
        0,
        TabSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabsRemovedInfoMojoType {
  tabIds: number[];
  recentlyClosedTabs: RecentlyClosedTab[];
}


export type TabsRemovedInfo = TabsRemovedInfoMojoType;
mojo.internal.Struct<TabsRemovedInfoMojoType>(
    TabsRemovedInfoSpec.$,
    'TabsRemovedInfo',
    [
      mojo.internal.StructField<TabsRemovedInfoMojoType, number[]>(
        'tabIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabsRemovedInfoMojoType, RecentlyClosedTab[]>(
        'recentlyClosedTabs', 8,
        0,
        mojo.internal.Array(RecentlyClosedTabSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UnusedTabInfoMojoType {
  staleTabs: Tab[];
  duplicateTabs: {[key: string]: Tab[]};
}


export type UnusedTabInfo = UnusedTabInfoMojoType;
mojo.internal.Struct<UnusedTabInfoMojoType>(
    UnusedTabInfoSpec.$,
    'UnusedTabInfo',
    [
      mojo.internal.StructField<UnusedTabInfoMojoType, Tab[]>(
        'staleTabs', 0,
        0,
        mojo.internal.Array(TabSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UnusedTabInfoMojoType, {[key: string]: Tab[]}>(
        'duplicateTabs', 8,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Array(TabSpec.$, false), false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_CloseTab_ParamsMojoType {
  tabId: number;
}


export type PageHandler_CloseTab_Params = PageHandler_CloseTab_ParamsMojoType;
mojo.internal.Struct<PageHandler_CloseTab_ParamsMojoType>(
    PageHandler_CloseTab_ParamsSpec.$,
    'PageHandler_CloseTab_Params',
    [
      mojo.internal.StructField<PageHandler_CloseTab_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_CloseWebUiTab_ParamsMojoType {
}


export type PageHandler_CloseWebUiTab_Params = PageHandler_CloseWebUiTab_ParamsMojoType;
mojo.internal.Struct<PageHandler_CloseWebUiTab_ParamsMojoType>(
    PageHandler_CloseWebUiTab_ParamsSpec.$,
    'PageHandler_CloseWebUiTab_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_DeclutterTabs_ParamsMojoType {
  tabIds: number[];
  urls: url_mojom_Url[];
}


export type PageHandler_DeclutterTabs_Params = PageHandler_DeclutterTabs_ParamsMojoType;
mojo.internal.Struct<PageHandler_DeclutterTabs_ParamsMojoType>(
    PageHandler_DeclutterTabs_ParamsSpec.$,
    'PageHandler_DeclutterTabs_Params',
    [
      mojo.internal.StructField<PageHandler_DeclutterTabs_ParamsMojoType, number[]>(
        'tabIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_DeclutterTabs_ParamsMojoType, url_mojom_Url[]>(
        'urls', 8,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_AcceptTabOrganization_ParamsMojoType {
  sessionId: number;
  organizationId: number;
  tabs: Tab[];
}


export type PageHandler_AcceptTabOrganization_Params = PageHandler_AcceptTabOrganization_ParamsMojoType;
mojo.internal.Struct<PageHandler_AcceptTabOrganization_ParamsMojoType>(
    PageHandler_AcceptTabOrganization_ParamsSpec.$,
    'PageHandler_AcceptTabOrganization_Params',
    [
      mojo.internal.StructField<PageHandler_AcceptTabOrganization_ParamsMojoType, number>(
        'sessionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_AcceptTabOrganization_ParamsMojoType, number>(
        'organizationId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_AcceptTabOrganization_ParamsMojoType, Tab[]>(
        'tabs', 8,
        0,
        mojo.internal.Array(TabSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RejectTabOrganization_ParamsMojoType {
  sessionId: number;
  organizationId: number;
}


export type PageHandler_RejectTabOrganization_Params = PageHandler_RejectTabOrganization_ParamsMojoType;
mojo.internal.Struct<PageHandler_RejectTabOrganization_ParamsMojoType>(
    PageHandler_RejectTabOrganization_ParamsSpec.$,
    'PageHandler_RejectTabOrganization_Params',
    [
      mojo.internal.StructField<PageHandler_RejectTabOrganization_ParamsMojoType, number>(
        'sessionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RejectTabOrganization_ParamsMojoType, number>(
        'organizationId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RenameTabOrganization_ParamsMojoType {
  sessionId: number;
  organizationId: number;
  name: mojoBase_mojom_String16;
}


export type PageHandler_RenameTabOrganization_Params = PageHandler_RenameTabOrganization_ParamsMojoType;
mojo.internal.Struct<PageHandler_RenameTabOrganization_ParamsMojoType>(
    PageHandler_RenameTabOrganization_ParamsSpec.$,
    'PageHandler_RenameTabOrganization_Params',
    [
      mojo.internal.StructField<PageHandler_RenameTabOrganization_ParamsMojoType, number>(
        'sessionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RenameTabOrganization_ParamsMojoType, number>(
        'organizationId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RenameTabOrganization_ParamsMojoType, mojoBase_mojom_String16>(
        'name', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_ExcludeFromStaleTabs_ParamsMojoType {
  tabId: number;
}


export type PageHandler_ExcludeFromStaleTabs_Params = PageHandler_ExcludeFromStaleTabs_ParamsMojoType;
mojo.internal.Struct<PageHandler_ExcludeFromStaleTabs_ParamsMojoType>(
    PageHandler_ExcludeFromStaleTabs_ParamsSpec.$,
    'PageHandler_ExcludeFromStaleTabs_Params',
    [
      mojo.internal.StructField<PageHandler_ExcludeFromStaleTabs_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ExcludeFromDuplicateTabs_ParamsMojoType {
  url: url_mojom_Url;
}


export type PageHandler_ExcludeFromDuplicateTabs_Params = PageHandler_ExcludeFromDuplicateTabs_ParamsMojoType;
mojo.internal.Struct<PageHandler_ExcludeFromDuplicateTabs_ParamsMojoType>(
    PageHandler_ExcludeFromDuplicateTabs_ParamsSpec.$,
    'PageHandler_ExcludeFromDuplicateTabs_Params',
    [
      mojo.internal.StructField<PageHandler_ExcludeFromDuplicateTabs_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetProfileData_ParamsMojoType {
}


export type PageHandler_GetProfileData_Params = PageHandler_GetProfileData_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetProfileData_ParamsMojoType>(
    PageHandler_GetProfileData_ParamsSpec.$,
    'PageHandler_GetProfileData_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetProfileData_ResponseParamsMojoType {
  profileData: ProfileData;
}


export type PageHandler_GetProfileData_ResponseParams = PageHandler_GetProfileData_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetProfileData_ResponseParamsMojoType>(
    PageHandler_GetProfileData_ResponseParamsSpec.$,
    'PageHandler_GetProfileData_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetProfileData_ResponseParamsMojoType, ProfileData>(
        'profileData', 0,
        0,
        ProfileDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetUnusedTabs_ParamsMojoType {
}


export type PageHandler_GetUnusedTabs_Params = PageHandler_GetUnusedTabs_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetUnusedTabs_ParamsMojoType>(
    PageHandler_GetUnusedTabs_ParamsSpec.$,
    'PageHandler_GetUnusedTabs_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetUnusedTabs_ResponseParamsMojoType {
  tabs: UnusedTabInfo;
}


export type PageHandler_GetUnusedTabs_ResponseParams = PageHandler_GetUnusedTabs_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetUnusedTabs_ResponseParamsMojoType>(
    PageHandler_GetUnusedTabs_ResponseParamsSpec.$,
    'PageHandler_GetUnusedTabs_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetUnusedTabs_ResponseParamsMojoType, UnusedTabInfo>(
        'tabs', 0,
        0,
        UnusedTabInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetTabSearchSection_ParamsMojoType {
}


export type PageHandler_GetTabSearchSection_Params = PageHandler_GetTabSearchSection_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabSearchSection_ParamsMojoType>(
    PageHandler_GetTabSearchSection_ParamsSpec.$,
    'PageHandler_GetTabSearchSection_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetTabSearchSection_ResponseParamsMojoType {
  section: TabSearchSection;
}


export type PageHandler_GetTabSearchSection_ResponseParams = PageHandler_GetTabSearchSection_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabSearchSection_ResponseParamsMojoType>(
    PageHandler_GetTabSearchSection_ResponseParamsSpec.$,
    'PageHandler_GetTabSearchSection_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetTabSearchSection_ResponseParamsMojoType, TabSearchSection>(
        'section', 0,
        0,
        TabSearchSectionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetTabOrganizationFeature_ParamsMojoType {
}


export type PageHandler_GetTabOrganizationFeature_Params = PageHandler_GetTabOrganizationFeature_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabOrganizationFeature_ParamsMojoType>(
    PageHandler_GetTabOrganizationFeature_ParamsSpec.$,
    'PageHandler_GetTabOrganizationFeature_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetTabOrganizationFeature_ResponseParamsMojoType {
  feature: TabOrganizationFeature;
}


export type PageHandler_GetTabOrganizationFeature_ResponseParams = PageHandler_GetTabOrganizationFeature_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabOrganizationFeature_ResponseParamsMojoType>(
    PageHandler_GetTabOrganizationFeature_ResponseParamsSpec.$,
    'PageHandler_GetTabOrganizationFeature_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetTabOrganizationFeature_ResponseParamsMojoType, TabOrganizationFeature>(
        'feature', 0,
        0,
        TabOrganizationFeatureSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetTabOrganizationSession_ParamsMojoType {
}


export type PageHandler_GetTabOrganizationSession_Params = PageHandler_GetTabOrganizationSession_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabOrganizationSession_ParamsMojoType>(
    PageHandler_GetTabOrganizationSession_ParamsSpec.$,
    'PageHandler_GetTabOrganizationSession_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetTabOrganizationSession_ResponseParamsMojoType {
  session: TabOrganizationSession;
}


export type PageHandler_GetTabOrganizationSession_ResponseParams = PageHandler_GetTabOrganizationSession_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabOrganizationSession_ResponseParamsMojoType>(
    PageHandler_GetTabOrganizationSession_ResponseParamsSpec.$,
    'PageHandler_GetTabOrganizationSession_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetTabOrganizationSession_ResponseParamsMojoType, TabOrganizationSession>(
        'session', 0,
        0,
        TabOrganizationSessionSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetTabOrganizationModelStrategy_ParamsMojoType {
}


export type PageHandler_GetTabOrganizationModelStrategy_Params = PageHandler_GetTabOrganizationModelStrategy_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabOrganizationModelStrategy_ParamsMojoType>(
    PageHandler_GetTabOrganizationModelStrategy_ParamsSpec.$,
    'PageHandler_GetTabOrganizationModelStrategy_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetTabOrganizationModelStrategy_ResponseParamsMojoType {
  strategy: TabOrganizationModelStrategy;
}


export type PageHandler_GetTabOrganizationModelStrategy_ResponseParams = PageHandler_GetTabOrganizationModelStrategy_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabOrganizationModelStrategy_ResponseParamsMojoType>(
    PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec.$,
    'PageHandler_GetTabOrganizationModelStrategy_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetTabOrganizationModelStrategy_ResponseParamsMojoType, TabOrganizationModelStrategy>(
        'strategy', 0,
        0,
        TabOrganizationModelStrategySpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetIsSplit_ParamsMojoType {
}


export type PageHandler_GetIsSplit_Params = PageHandler_GetIsSplit_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetIsSplit_ParamsMojoType>(
    PageHandler_GetIsSplit_ParamsSpec.$,
    'PageHandler_GetIsSplit_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetIsSplit_ResponseParamsMojoType {
  isSplit: boolean;
}


export type PageHandler_GetIsSplit_ResponseParams = PageHandler_GetIsSplit_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetIsSplit_ResponseParamsMojoType>(
    PageHandler_GetIsSplit_ResponseParamsSpec.$,
    'PageHandler_GetIsSplit_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetIsSplit_ResponseParamsMojoType, boolean>(
        'isSplit', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SwitchToTab_ParamsMojoType {
  switchToTabInfo: SwitchToTabInfo;
}


export type PageHandler_SwitchToTab_Params = PageHandler_SwitchToTab_ParamsMojoType;
mojo.internal.Struct<PageHandler_SwitchToTab_ParamsMojoType>(
    PageHandler_SwitchToTab_ParamsSpec.$,
    'PageHandler_SwitchToTab_Params',
    [
      mojo.internal.StructField<PageHandler_SwitchToTab_ParamsMojoType, SwitchToTabInfo>(
        'switchToTabInfo', 0,
        0,
        SwitchToTabInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OpenRecentlyClosedEntry_ParamsMojoType {
  sessionId: number;
}


export type PageHandler_OpenRecentlyClosedEntry_Params = PageHandler_OpenRecentlyClosedEntry_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenRecentlyClosedEntry_ParamsMojoType>(
    PageHandler_OpenRecentlyClosedEntry_ParamsSpec.$,
    'PageHandler_OpenRecentlyClosedEntry_Params',
    [
      mojo.internal.StructField<PageHandler_OpenRecentlyClosedEntry_ParamsMojoType, number>(
        'sessionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RequestTabOrganization_ParamsMojoType {
}


export type PageHandler_RequestTabOrganization_Params = PageHandler_RequestTabOrganization_ParamsMojoType;
mojo.internal.Struct<PageHandler_RequestTabOrganization_ParamsMojoType>(
    PageHandler_RequestTabOrganization_ParamsSpec.$,
    'PageHandler_RequestTabOrganization_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RemoveTabFromOrganization_ParamsMojoType {
  sessionId: number;
  organizationId: number;
  tab: Tab;
}


export type PageHandler_RemoveTabFromOrganization_Params = PageHandler_RemoveTabFromOrganization_ParamsMojoType;
mojo.internal.Struct<PageHandler_RemoveTabFromOrganization_ParamsMojoType>(
    PageHandler_RemoveTabFromOrganization_ParamsSpec.$,
    'PageHandler_RemoveTabFromOrganization_Params',
    [
      mojo.internal.StructField<PageHandler_RemoveTabFromOrganization_ParamsMojoType, number>(
        'sessionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RemoveTabFromOrganization_ParamsMojoType, number>(
        'organizationId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RemoveTabFromOrganization_ParamsMojoType, Tab>(
        'tab', 8,
        0,
        TabSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RejectSession_ParamsMojoType {
  sessionId: number;
}


export type PageHandler_RejectSession_Params = PageHandler_RejectSession_ParamsMojoType;
mojo.internal.Struct<PageHandler_RejectSession_ParamsMojoType>(
    PageHandler_RejectSession_ParamsSpec.$,
    'PageHandler_RejectSession_Params',
    [
      mojo.internal.StructField<PageHandler_RejectSession_ParamsMojoType, number>(
        'sessionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ReplaceActiveSplitTab_ParamsMojoType {
  replacementTabId: number;
}


export type PageHandler_ReplaceActiveSplitTab_Params = PageHandler_ReplaceActiveSplitTab_ParamsMojoType;
mojo.internal.Struct<PageHandler_ReplaceActiveSplitTab_ParamsMojoType>(
    PageHandler_ReplaceActiveSplitTab_ParamsSpec.$,
    'PageHandler_ReplaceActiveSplitTab_Params',
    [
      mojo.internal.StructField<PageHandler_ReplaceActiveSplitTab_ParamsMojoType, number>(
        'replacementTabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RestartSession_ParamsMojoType {
}


export type PageHandler_RestartSession_Params = PageHandler_RestartSession_ParamsMojoType;
mojo.internal.Struct<PageHandler_RestartSession_ParamsMojoType>(
    PageHandler_RestartSession_ParamsSpec.$,
    'PageHandler_RestartSession_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_SaveRecentlyClosedExpandedPref_ParamsMojoType {
  expanded: boolean;
}


export type PageHandler_SaveRecentlyClosedExpandedPref_Params = PageHandler_SaveRecentlyClosedExpandedPref_ParamsMojoType;
mojo.internal.Struct<PageHandler_SaveRecentlyClosedExpandedPref_ParamsMojoType>(
    PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec.$,
    'PageHandler_SaveRecentlyClosedExpandedPref_Params',
    [
      mojo.internal.StructField<PageHandler_SaveRecentlyClosedExpandedPref_ParamsMojoType, boolean>(
        'expanded', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetOrganizationFeature_ParamsMojoType {
  feature: TabOrganizationFeature;
}


export type PageHandler_SetOrganizationFeature_Params = PageHandler_SetOrganizationFeature_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetOrganizationFeature_ParamsMojoType>(
    PageHandler_SetOrganizationFeature_ParamsSpec.$,
    'PageHandler_SetOrganizationFeature_Params',
    [
      mojo.internal.StructField<PageHandler_SetOrganizationFeature_ParamsMojoType, TabOrganizationFeature>(
        'feature', 0,
        0,
        TabOrganizationFeatureSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_StartTabGroupTutorial_ParamsMojoType {
}


export type PageHandler_StartTabGroupTutorial_Params = PageHandler_StartTabGroupTutorial_ParamsMojoType;
mojo.internal.Struct<PageHandler_StartTabGroupTutorial_ParamsMojoType>(
    PageHandler_StartTabGroupTutorial_ParamsSpec.$,
    'PageHandler_StartTabGroupTutorial_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_TriggerFeedback_ParamsMojoType {
  sessionId: number;
}


export type PageHandler_TriggerFeedback_Params = PageHandler_TriggerFeedback_ParamsMojoType;
mojo.internal.Struct<PageHandler_TriggerFeedback_ParamsMojoType>(
    PageHandler_TriggerFeedback_ParamsSpec.$,
    'PageHandler_TriggerFeedback_Params',
    [
      mojo.internal.StructField<PageHandler_TriggerFeedback_ParamsMojoType, number>(
        'sessionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_TriggerSignIn_ParamsMojoType {
}


export type PageHandler_TriggerSignIn_Params = PageHandler_TriggerSignIn_ParamsMojoType;
mojo.internal.Struct<PageHandler_TriggerSignIn_ParamsMojoType>(
    PageHandler_TriggerSignIn_ParamsSpec.$,
    'PageHandler_TriggerSignIn_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OpenHelpPage_ParamsMojoType {
}


export type PageHandler_OpenHelpPage_Params = PageHandler_OpenHelpPage_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenHelpPage_ParamsMojoType>(
    PageHandler_OpenHelpPage_ParamsSpec.$,
    'PageHandler_OpenHelpPage_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_SetTabOrganizationModelStrategy_ParamsMojoType {
  strategy: TabOrganizationModelStrategy;
}


export type PageHandler_SetTabOrganizationModelStrategy_Params = PageHandler_SetTabOrganizationModelStrategy_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetTabOrganizationModelStrategy_ParamsMojoType>(
    PageHandler_SetTabOrganizationModelStrategy_ParamsSpec.$,
    'PageHandler_SetTabOrganizationModelStrategy_Params',
    [
      mojo.internal.StructField<PageHandler_SetTabOrganizationModelStrategy_ParamsMojoType, TabOrganizationModelStrategy>(
        'strategy', 0,
        0,
        TabOrganizationModelStrategySpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetTabOrganizationUserInstruction_ParamsMojoType {
  userInstruction: string;
}


export type PageHandler_SetTabOrganizationUserInstruction_Params = PageHandler_SetTabOrganizationUserInstruction_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetTabOrganizationUserInstruction_ParamsMojoType>(
    PageHandler_SetTabOrganizationUserInstruction_ParamsSpec.$,
    'PageHandler_SetTabOrganizationUserInstruction_Params',
    [
      mojo.internal.StructField<PageHandler_SetTabOrganizationUserInstruction_ParamsMojoType, string>(
        'userInstruction', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetUserFeedback_ParamsMojoType {
  sessionId: number;
  feedback: UserFeedback;
}


export type PageHandler_SetUserFeedback_Params = PageHandler_SetUserFeedback_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetUserFeedback_ParamsMojoType>(
    PageHandler_SetUserFeedback_ParamsSpec.$,
    'PageHandler_SetUserFeedback_Params',
    [
      mojo.internal.StructField<PageHandler_SetUserFeedback_ParamsMojoType, number>(
        'sessionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetUserFeedback_ParamsMojoType, UserFeedback>(
        'feedback', 4,
        0,
        UserFeedbackSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_NotifyOrganizationUIReadyToShow_ParamsMojoType {
}


export type PageHandler_NotifyOrganizationUIReadyToShow_Params = PageHandler_NotifyOrganizationUIReadyToShow_ParamsMojoType;
mojo.internal.Struct<PageHandler_NotifyOrganizationUIReadyToShow_ParamsMojoType>(
    PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec.$,
    'PageHandler_NotifyOrganizationUIReadyToShow_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_NotifySearchUIReadyToShow_ParamsMojoType {
}


export type PageHandler_NotifySearchUIReadyToShow_Params = PageHandler_NotifySearchUIReadyToShow_ParamsMojoType;
mojo.internal.Struct<PageHandler_NotifySearchUIReadyToShow_ParamsMojoType>(
    PageHandler_NotifySearchUIReadyToShow_ParamsSpec.$,
    'PageHandler_NotifySearchUIReadyToShow_Params',
    [
    ],
    [[0, 8],]);





export interface Page_TabOrganizationSessionUpdated_ParamsMojoType {
  session: TabOrganizationSession;
}


export type Page_TabOrganizationSessionUpdated_Params = Page_TabOrganizationSessionUpdated_ParamsMojoType;
mojo.internal.Struct<Page_TabOrganizationSessionUpdated_ParamsMojoType>(
    Page_TabOrganizationSessionUpdated_ParamsSpec.$,
    'Page_TabOrganizationSessionUpdated_Params',
    [
      mojo.internal.StructField<Page_TabOrganizationSessionUpdated_ParamsMojoType, TabOrganizationSession>(
        'session', 0,
        0,
        TabOrganizationSessionSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_TabOrganizationModelStrategyUpdated_ParamsMojoType {
  strategy: TabOrganizationModelStrategy;
}


export type Page_TabOrganizationModelStrategyUpdated_Params = Page_TabOrganizationModelStrategyUpdated_ParamsMojoType;
mojo.internal.Struct<Page_TabOrganizationModelStrategyUpdated_ParamsMojoType>(
    Page_TabOrganizationModelStrategyUpdated_ParamsSpec.$,
    'Page_TabOrganizationModelStrategyUpdated_Params',
    [
      mojo.internal.StructField<Page_TabOrganizationModelStrategyUpdated_ParamsMojoType, TabOrganizationModelStrategy>(
        'strategy', 0,
        0,
        TabOrganizationModelStrategySpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_HostWindowChanged_ParamsMojoType {
}


export type Page_HostWindowChanged_Params = Page_HostWindowChanged_ParamsMojoType;
mojo.internal.Struct<Page_HostWindowChanged_ParamsMojoType>(
    Page_HostWindowChanged_ParamsSpec.$,
    'Page_HostWindowChanged_Params',
    [
    ],
    [[0, 8],]);





export interface Page_TabsChanged_ParamsMojoType {
  profileTabs: ProfileData;
}


export type Page_TabsChanged_Params = Page_TabsChanged_ParamsMojoType;
mojo.internal.Struct<Page_TabsChanged_ParamsMojoType>(
    Page_TabsChanged_ParamsSpec.$,
    'Page_TabsChanged_Params',
    [
      mojo.internal.StructField<Page_TabsChanged_ParamsMojoType, ProfileData>(
        'profileTabs', 0,
        0,
        ProfileDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_TabUpdated_ParamsMojoType {
  tabUpdateInfo: TabUpdateInfo;
}


export type Page_TabUpdated_Params = Page_TabUpdated_ParamsMojoType;
mojo.internal.Struct<Page_TabUpdated_ParamsMojoType>(
    Page_TabUpdated_ParamsSpec.$,
    'Page_TabUpdated_Params',
    [
      mojo.internal.StructField<Page_TabUpdated_ParamsMojoType, TabUpdateInfo>(
        'tabUpdateInfo', 0,
        0,
        TabUpdateInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_TabsRemoved_ParamsMojoType {
  tabsRemovedInfo: TabsRemovedInfo;
}


export type Page_TabsRemoved_Params = Page_TabsRemoved_ParamsMojoType;
mojo.internal.Struct<Page_TabsRemoved_ParamsMojoType>(
    Page_TabsRemoved_ParamsSpec.$,
    'Page_TabsRemoved_Params',
    [
      mojo.internal.StructField<Page_TabsRemoved_ParamsMojoType, TabsRemovedInfo>(
        'tabsRemovedInfo', 0,
        0,
        TabsRemovedInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_TabSearchSectionChanged_ParamsMojoType {
  section: TabSearchSection;
}


export type Page_TabSearchSectionChanged_Params = Page_TabSearchSectionChanged_ParamsMojoType;
mojo.internal.Struct<Page_TabSearchSectionChanged_ParamsMojoType>(
    Page_TabSearchSectionChanged_ParamsSpec.$,
    'Page_TabSearchSectionChanged_Params',
    [
      mojo.internal.StructField<Page_TabSearchSectionChanged_ParamsMojoType, TabSearchSection>(
        'section', 0,
        0,
        TabSearchSectionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_TabOrganizationFeatureChanged_ParamsMojoType {
  feature: TabOrganizationFeature;
}


export type Page_TabOrganizationFeatureChanged_Params = Page_TabOrganizationFeatureChanged_ParamsMojoType;
mojo.internal.Struct<Page_TabOrganizationFeatureChanged_ParamsMojoType>(
    Page_TabOrganizationFeatureChanged_ParamsSpec.$,
    'Page_TabOrganizationFeatureChanged_Params',
    [
      mojo.internal.StructField<Page_TabOrganizationFeatureChanged_ParamsMojoType, TabOrganizationFeature>(
        'feature', 0,
        0,
        TabOrganizationFeatureSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_ShowFREChanged_ParamsMojoType {
  show: boolean;
}


export type Page_ShowFREChanged_Params = Page_ShowFREChanged_ParamsMojoType;
mojo.internal.Struct<Page_ShowFREChanged_ParamsMojoType>(
    Page_ShowFREChanged_ParamsSpec.$,
    'Page_ShowFREChanged_Params',
    [
      mojo.internal.StructField<Page_ShowFREChanged_ParamsMojoType, boolean>(
        'show', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_TabOrganizationEnabledChanged_ParamsMojoType {
  enabled: boolean;
}


export type Page_TabOrganizationEnabledChanged_Params = Page_TabOrganizationEnabledChanged_ParamsMojoType;
mojo.internal.Struct<Page_TabOrganizationEnabledChanged_ParamsMojoType>(
    Page_TabOrganizationEnabledChanged_ParamsSpec.$,
    'Page_TabOrganizationEnabledChanged_Params',
    [
      mojo.internal.StructField<Page_TabOrganizationEnabledChanged_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_UnusedTabsChanged_ParamsMojoType {
  tabs: UnusedTabInfo;
}


export type Page_UnusedTabsChanged_Params = Page_UnusedTabsChanged_ParamsMojoType;
mojo.internal.Struct<Page_UnusedTabsChanged_ParamsMojoType>(
    Page_UnusedTabsChanged_ParamsSpec.$,
    'Page_UnusedTabsChanged_Params',
    [
      mojo.internal.StructField<Page_UnusedTabsChanged_ParamsMojoType, UnusedTabInfo>(
        'tabs', 0,
        0,
        UnusedTabInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_TabUnsplit_ParamsMojoType {
}


export type Page_TabUnsplit_Params = Page_TabUnsplit_ParamsMojoType;
mojo.internal.Struct<Page_TabUnsplit_ParamsMojoType>(
    Page_TabUnsplit_ParamsSpec.$,
    'Page_TabUnsplit_Params',
    [
    ],
    [[0, 8],]);



