import './support_tool_shared.css.js';
import '/strings.m.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_checkbox/cr_checkbox.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import 'chrome://resources/polymer/v3_0/iron-list/iron-list.js';
import type { CrToastElement } from 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface UrlGeneratorElement {
    $: {
        copyToast: CrToastElement;
        errorMessageToast: CrToastElement;
    };
}
declare const UrlGeneratorElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class UrlGeneratorElement extends UrlGeneratorElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        caseId_: {
            type: StringConstructor;
            value: string;
        };
        dataCollectors_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        errorMessage_: {
            type: StringConstructor;
            value: string;
        };
        buttonDisabled_: {
            type: BooleanConstructor;
            value: boolean;
        };
        copiedToastMessage_: {
            type: StringConstructor;
            value: string;
        };
        selectAll_: {
            type: BooleanConstructor;
            value: boolean;
            notify: boolean;
            observer: string;
        };
    };
    private caseId_;
    private generatedResult_;
    private errorMessage_;
    private buttonDisabled_;
    private copiedToastMessage_;
    private dataCollectors_;
    private selectAll_;
    private browserProxy_;
    connectedCallback(): void;
    private onDataCollectorItemChange_;
    private hasDataCollectorSelected;
    private showErrorMessageToast_;
    private showGenerationResult;
    private onUrlGenerationResult_;
    private onTokenGenerationResult_;
    private onCopyUrlClick_;
    private onCopyTokenClick_;
    private onErrorMessageToastCloseClicked_;
    private onAllSelectedChanged_;
}
declare global {
    interface HTMLElementTagNameMap {
        'url-generator': UrlGeneratorElement;
    }
}
export {};
