/**
 * @fileoverview Mixin to be used by Polymer elements that define Support Tool
 * pages.
 */
import type { I18nMixinInterface } from 'chrome://resources/cr_elements/i18n_mixin.js';
import type { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
type Constructor<T> = new (...args: any[]) => T;
export declare const SupportToolPageMixin: <T extends Constructor<PolymerElement>>(superClass: T) => T & Constructor<SupportToolPageMixinInterface>;
export interface SupportToolPageMixinInterface extends I18nMixinInterface {
    $$<E extends Element = Element>(query: string): E | null;
    ensureFocusOnPageHeader(): void;
}
export {};
