import './icons.html.js';
import './support_tool_shared.css.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare const ScreenshotElementBase: typeof PolymerElement & (new (...args: any[]) => import("./support_tool_page_mixin.js").SupportToolPageMixinInterface);
export declare class ScreenshotElement extends ScreenshotElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        hasScreenshotPreview_: {
            type: BooleanConstructor;
            value: boolean;
        };
        screenshotBase64_: {
            type: StringConstructor;
            value: string;
        };
        originalScreenshotBase64_: {
            type: StringConstructor;
            value: string;
        };
        showEditor_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showDeleteButton_: {
            type: BooleanConstructor;
            value: boolean;
        };
        buttonX_: {
            type: NumberConstructor;
            value: number;
        };
        buttonY_: {
            type: NumberConstructor;
            value: number;
        };
    };
    private hasScreenshotPreview_;
    private screenshotBase64_;
    private originalScreenshotBase64_;
    private showEditor_;
    private canvasX_;
    private canvasY_;
    private context_;
    private rects_;
    private confirmedRects_;
    private cornerX_;
    private cornerY_;
    private mouseDown_;
    private showDeleteButton_;
    private selectedRect_;
    private buttonX_;
    private buttonY_;
    private browserProxy_;
    setScreenshotData(dataBase64: string): void;
    getEditedScreenshotBase64(): string;
    getOriginalScreenshotBase64(): string;
    private onTakeScreenshotClick_;
    private onRemoveScreenshotClick_;
    private onEditScreenshotClick_;
    private onOpenDialog_;
    private onCoordsChanged_;
    private onCanvasMouseDown_;
    private onCanvasMouseMove_;
    private onCanvasMouseUp_;
    private onClickDeleteRect_;
    private onClickConfirm_;
    private onCloseDialog_;
    private onClickCancel_;
}
declare global {
    interface HTMLElementTagNameMap {
        'screenshot-element': ScreenshotElement;
    }
}
export {};
