import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><!--
Copyright 2022 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="support-tool-shared cr-shared-style"></style>

<h1 tabindex="0">$i18n{dataSelectionPageTitle}</h1>

<cr-checkbox class="select-all-checkbox" id="selectAllCheckbox"
  checked="{{allSelected_}}" tabindex="0">
    $i18n{selectAll}
</cr-checkbox>

<div class="data-collector-list">
  <template is="dom-repeat" items="[[dataCollectors_]]">
    <cr-checkbox class="data-collector-checkbox" checked="{{item.isIncluded}}"
        tabindex="0">
      [[item.name]]
    </cr-checkbox>
  </template>
</div>

<template is="dom-if" if="[[enableScreenshot_]]" restamp>
  <screenshot-element id="screenshot"></screenshot-element>
</template>
<!--_html_template_end_-->`;
}