// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_button/cr_button.js";import"chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js";import"chrome://resources/cr_elements/cr_toast/cr_toast.js";import"./data_collectors.js";import"./issue_details.js";import"./spinner_page.js";import"./pii_selection.js";import"./data_export_done.js";import"./support_tool_shared.css.js";import{WebUiListenerMixin}from"chrome://resources/cr_elements/web_ui_listener_mixin.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{getTemplate}from"./support_tool.html.js";export var SupportToolPageIndex;(function(SupportToolPageIndex){SupportToolPageIndex[SupportToolPageIndex["ISSUE_DETAILS"]=0]="ISSUE_DETAILS";SupportToolPageIndex[SupportToolPageIndex["DATA_COLLECTOR_SELECTION"]=1]="DATA_COLLECTOR_SELECTION";SupportToolPageIndex[SupportToolPageIndex["SPINNER"]=2]="SPINNER";SupportToolPageIndex[SupportToolPageIndex["PII_SELECTION"]=3]="PII_SELECTION";SupportToolPageIndex[SupportToolPageIndex["EXPORT_SPINNER"]=4]="EXPORT_SPINNER";SupportToolPageIndex[SupportToolPageIndex["DATA_EXPORT_DONE"]=5]="DATA_EXPORT_DONE"})(SupportToolPageIndex||(SupportToolPageIndex={}));const SupportToolElementBase=WebUiListenerMixin(PolymerElement);export class SupportToolElement extends SupportToolElementBase{static get is(){return"support-tool"}static get template(){return getTemplate()}static get properties(){return{selectedPage_:{type:SupportToolPageIndex,value:SupportToolPageIndex.ISSUE_DETAILS,observer:"onSelectedPageChange_"},supportToolPageIndexEnum_:{readonly:true,type:Object,value:SupportToolPageIndex},errorMessage_:{type:String,value:""}}}browserProxy_=BrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.addWebUiListener("screenshot-received",this.onScreenshotReceived_.bind(this));this.addWebUiListener("data-collection-completed",this.onDataCollectionCompleted_.bind(this));this.addWebUiListener("data-collection-cancelled",this.onDataCollectionCancelled_.bind(this));this.addWebUiListener("support-data-export-started",this.onDataExportStarted_.bind(this));this.addWebUiListener("data-export-completed",this.onDataExportCompleted_.bind(this))}onScreenshotReceived_(screenshotBase64){if(screenshotBase64!=="CANCELED"){this.$.dataCollectors.setScreenshotData(screenshotBase64)}}onDataExportStarted_(){this.selectedPage_=SupportToolPageIndex.EXPORT_SPINNER}onDataCollectionCompleted_(piiItems){this.$.piiSelection.updateDetectedPiiItems(piiItems);this.selectedPage_=SupportToolPageIndex.PII_SELECTION}onDataCollectionCancelled_(){this.selectedPage_=SupportToolPageIndex.ISSUE_DETAILS}displayError_(errorMessage){this.errorMessage_=errorMessage;this.$.errorMessageToast.show()}onDataExportCompleted_(result){if(result.success){this.$.dataExportDone.setPath(result.path);this.selectedPage_=SupportToolPageIndex.DATA_EXPORT_DONE}else{this.selectedPage_=SupportToolPageIndex.PII_SELECTION;this.displayError_(result.error)}}onDataCollectionStart_(result){if(result.success){this.selectedPage_=SupportToolPageIndex.SPINNER}else{this.displayError_(result.errorMessage)}}onErrorMessageToastCloseClicked_(){this.$.errorMessageToast.hide()}onContinueClick_(){if(this.selectedPage_===SupportToolPageIndex.DATA_COLLECTOR_SELECTION){this.browserProxy_.startDataCollection(this.$.issueDetails.getIssueDetails(),this.$.dataCollectors.getDataCollectors(),this.$.dataCollectors.getEditedScreenshotBase64()).then(this.onDataCollectionStart_.bind(this))}else{this.selectedPage_=this.selectedPage_+1}}onBackClick_(){this.selectedPage_=this.selectedPage_-1}shouldHideBackButton_(){return this.selectedPage_!==SupportToolPageIndex.DATA_COLLECTOR_SELECTION}shouldHideContinueButtonContainer_(){return this.selectedPage_>=SupportToolPageIndex.SPINNER}onSelectedPageChange_(){switch(this.selectedPage_){case SupportToolPageIndex.ISSUE_DETAILS:this.$.issueDetails.ensureFocusOnPageHeader();break;case SupportToolPageIndex.DATA_COLLECTOR_SELECTION:this.$.dataCollectors.ensureFocusOnPageHeader();break;case SupportToolPageIndex.SPINNER:this.$.spinnerPage.ensureFocusOnPageHeader();break;case SupportToolPageIndex.PII_SELECTION:this.$.piiSelection.ensureFocusOnPageHeader();break;case SupportToolPageIndex.EXPORT_SPINNER:this.$.exportSpinner.ensureFocusOnPageHeader();break;case SupportToolPageIndex.DATA_EXPORT_DONE:this.$.dataExportDone.ensureFocusOnPageHeader();break;default:break}}}customElements.define(SupportToolElement.is,SupportToolElement);