// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A helper object used by the managed user profile notice screen
 * to interact with the browser.
 */
import { sendWithPromise } from 'chrome://resources/js/cr.js';
export var BrowsingDataHandling;
(function (BrowsingDataHandling) {
    BrowsingDataHandling["MERGE"] = "merge";
    BrowsingDataHandling["SEPARATE"] = "separate";
})(BrowsingDataHandling || (BrowsingDataHandling = {}));
export var State;
(function (State) {
    State[State["DISCLOSURE"] = 0] = "DISCLOSURE";
    State[State["PROCESSING"] = 1] = "PROCESSING";
    State[State["SUCCESS"] = 2] = "SUCCESS";
    State[State["TIMEOUT"] = 3] = "TIMEOUT";
    State[State["ERROR"] = 4] = "ERROR";
    State[State["VALUE_PROPOSITION"] = 5] = "VALUE_PROPOSITION";
    State[State["USER_DATA_HANDLING"] = 6] = "USER_DATA_HANDLING";
})(State || (State = {}));
export class ManagedUserProfileNoticeBrowserProxyImpl {
    initialized() {
        return sendWithPromise('initialized');
    }
    initializedWithSize(height) {
        chrome.send('initializedWithSize', [height]);
    }
    proceed(state, linkData) {
        chrome.send('proceed', [state, linkData]);
    }
    cancel() {
        chrome.send('cancel');
    }
    static getInstance() {
        return instance ||
            (instance = new ManagedUserProfileNoticeBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
