import { d as getCss$2, e as getCss$3, W as WebUiListenerMixinLit, I as I18nMixinLit, r as createDummyAutogeneratedThemeColorInfo, M as ManageProfilesBrowserProxyImpl, f as focusWithoutInk, q as navigateToStep, P as ProfileCreationSteps, R as Routes, b as assert, s as recordPageVisited, t as navigateToPreviousRoute, h as createDummyProfileState } from './shared.rollup.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { css, html, CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import 'chrome://resources/js/cr.js';
import 'chrome://profile-picker/strings.m.js';

let instance$1 = null;
function getCss$1() {
    return instance$1 || (instance$1 = [...[getCss$2(), getCss$3()], css `:host{--avatar-size:100px;--banner-height:244px}#actionContainer{align-items:center;display:flex;flex-direction:column}#avatarContainer{bottom:calc(var(--avatar-size) / -2);height:calc(var(--avatar-size) + 4px);left:0;margin:auto;position:absolute;right:0;width:calc(var(--avatar-size) + 4px)}.avatar{border:2px solid var(--md-background-color);border-radius:50%;height:var(--avatar-size);width:var(--avatar-size);z-index:1}#backButton{--cr-icon-button-icon-size:22px;--cr-icon-button-margin-start:4px;--cr-icon-button-size:36px;margin-inline-start:16px;margin-top:4px;position:relative;z-index:1}@media (forced-colors:none){#backButton{--cr-icon-button-fill-color:var(--cr-secondary-text-color)}}#headerContainer{height:var(--banner-height);position:relative;width:100%}#infoContainer{bottom:0;box-sizing:border-box;margin-bottom:min(58px,calc(5px + 0.5 * (100vh - var(--view-min-size))));position:absolute;text-align:center;width:100%}.info-box{align-items:center;border:1px solid var(--google-grey-200);border-radius:8px;color:var(--google-grey-700);display:inline-flex;flex-direction:row;margin-inline:auto;max-width:780px;padding-block:12px;padding-inline-end:18px}.info-box>p{flex-grow:1;margin-block:0;text-align:start}.icon-container{--icon-container-size:28px;--icon-container-margin:16px;background-color:var(--google-grey-100);border-radius:50%;height:var(--icon-container-size);margin-inline:var(--icon-container-margin);width:var(--icon-container-size)}.icon-container cr-icon{--icon-size:16px;height:var(--icon-size);padding:calc((var(--icon-container-size) - var(--icon-size)) / 2);width:var(--icon-size)}cr-button{--cr-button-height:36px;font-size:0.75rem;font-weight:normal;min-width:210px}#notNowButton{margin-top:18px}.title-container{margin:104px 60px 48px;text-align:center}.title{font-size:2.25rem;font-weight:500;line-height:43px;margin-bottom:16px}.subtitle{font-size:1.25rem;line-height:24px}@media (prefers-color-scheme:dark){.info-box{border-color:var(--google-grey-600);color:var(--google-grey-100)}.icon-container{background-color:var(--google-grey-700)}}@media screen and ((max-width:780px) or (max-height:600px)){.title{font-size:1.5rem;line-height:32px}.subtitle{font-size:0.94rem}}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml$1() {
    return html `<!--_html_template_start_-->
<div id="headerContainer"
    .style="--theme-frame-color:${this.profileThemeInfo.themeFrameColor};
            --theme-text-color:${this.profileThemeInfo.themeFrameTextColor};">
  <!-- TODO(crbug.com/40267173): remove theme info across the profile picker -->
  <cr-icon-button id="backButton" iron-icon="cr:arrow-back"
      @click="${this.onBackClick_}"
      aria-label="${this.getBackButtonAriaLabel_()}"
      title="${this.getBackButtonAriaLabel_()}"
      ?disabled="${this.profileCreationInProgress}">
  </cr-icon-button>
  <div id="avatarContainer">
    <img class="avatar" alt=""
        src="${this.profileThemeInfo.themeGenericAvatar}">
  </div>
</div>
<div class="title-container">
  <h1 class="title">$i18n{profileTypeChoiceTitle}</h1>
  <div class="subtitle">$i18n{profileTypeChoiceSubtitle}</div>
</div>
<div id="actionContainer">
  <cr-button id="signInButton" class="action-button"
      @click="${this.onSignInClick_}"
      ?disabled="${this.profileCreationInProgress}">
    $i18n{signInButtonLabel}
  </cr-button>
  <cr-button id="notNowButton" @click="${this.onNotNowClick_}"
      ?disabled="${this.profileCreationInProgress}">
    $i18n{notNowButtonLabel}
  </cr-button>
</div>

${this.managedDeviceDisclaimer_ ? html `
  <div id="infoContainer">
    <div class="info-box">
      <div class="icon-container">
        <cr-icon icon="cr:domain"></cr-icon>
      </div>
      <p>$i18n{managedDeviceDisclaimer}</p>
    </div>
  </div>
` : ''}
<!--_html_template_end_-->`;
}

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ProfileTypeChoiceElementBase = WebUiListenerMixinLit(I18nMixinLit(CrLitElement));
class ProfileTypeChoiceElement extends ProfileTypeChoiceElementBase {
    static get is() {
        return 'profile-type-choice';
    }
    static get styles() {
        return getCss$1();
    }
    render() {
        return getHtml$1.bind(this)();
    }
    static get properties() {
        return {
            profileThemeInfo: { type: Object },
            /**
             * True if a new profile (local or signed-in) is being created, all
             * buttons that create a new profile are then disabled (to avoid creating
             * two profiles).
             */
            profileCreationInProgress: { type: Boolean },
            /**
             * The disclaimer for managed devices.
             */
            managedDeviceDisclaimer_: { type: Boolean },
        };
    }
    #profileThemeInfo_accessor_storage = createDummyAutogeneratedThemeColorInfo();
    get profileThemeInfo() { return this.#profileThemeInfo_accessor_storage; }
    set profileThemeInfo(value) { this.#profileThemeInfo_accessor_storage = value; }
    #profileCreationInProgress_accessor_storage = false;
    get profileCreationInProgress() { return this.#profileCreationInProgress_accessor_storage; }
    set profileCreationInProgress(value) { this.#profileCreationInProgress_accessor_storage = value; }
    #managedDeviceDisclaimer__accessor_storage = loadTimeData.getString('managedDeviceDisclaimer').length > 0;
    get managedDeviceDisclaimer_() { return this.#managedDeviceDisclaimer__accessor_storage; }
    set managedDeviceDisclaimer_(value) { this.#managedDeviceDisclaimer__accessor_storage = value; }
    manageProfilesBrowserProxy_ = ManageProfilesBrowserProxyImpl.getInstance();
    firstUpdated() {
        this.addWebUiListener('load-signin-finished', (success) => this.handleLoadSigninFinished_(success));
        this.manageProfilesBrowserProxy_.recordSignInPromoImpression();
        this.addEventListener('view-enter-start', this.onViewEnterStart_);
    }
    onViewEnterStart_() {
        focusWithoutInk(this.$.backButton);
    }
    onNotNowClick_() {
        navigateToStep(Routes.NEW_PROFILE, ProfileCreationSteps.LOCAL_PROFILE_CUSTOMIZATION);
    }
    onSignInClick_() {
        assert(!this.profileCreationInProgress);
        this.profileCreationInProgress = true;
        // Explicitly record the page visit as this step is not pushed to the
        // history stack.
        recordPageVisited(ProfileCreationSteps.LOAD_SIGNIN);
        this.manageProfilesBrowserProxy_.selectNewAccount(this.profileThemeInfo.color);
    }
    onBackClick_() {
        navigateToPreviousRoute();
    }
    handleLoadSigninFinished_(_success) {
        // TODO(crbug.com/40911651): If failed, show some error message to inform the
        // user.
        this.profileCreationInProgress = false;
    }
    getBackButtonAriaLabel_() {
        return this.i18n('backButtonAriaLabel', this.i18n('profileTypeChoiceTitle'));
    }
}
customElements.define(ProfileTypeChoiceElement.is, ProfileTypeChoiceElement);

let instance = null;
function getCss() {
    return instance || (instance = [...[getCss$3()], css `#outerContainer{display:flex;flex-flow:column;height:100%}#profileCardContainer{align-items:center;align-self:center;border:1px solid var(--google-grey-300);border-radius:8px;display:flex;flex-direction:column;height:var(--profile-item-height);justify-content:center;margin:200px 0 37px;position:relative;width:var(--profile-item-width)}#avatarContainer{height:var(--profile-card-avatar-icon-size);position:relative}#profileName{top:0}#gaiaName{bottom:0}#iconContainer{--iron-icon-height:16px;--iron-icon-width:16px;--domain-icon-size:24px;--domain-icon-border-size:2px;align-items:center;background-color:white;border:var(--domain-icon-border-size) solid var(--profile-card-hover-color);border-radius:50%;box-shadow:0 0 2px rgba(60,64,67,0.12),0 0 6px rgba(60,64,67,0.15);display:flex;height:var(--domain-icon-size);inset-inline-end:-6px;justify-content:center;position:absolute;top:calc(var(--profile-card-avatar-icon-size) - var(--domain-icon-size) - var(--domain-icon-border-size));width:var(--domain-icon-size)}cr-icon{--iron-icon-fill-color:var(--google-grey-700)}#titleContainer{text-align:center}.title{margin-block-start:0}#actionContainer{margin:auto 40px 40px auto}cr-button{margin-inline-start:8px;min-width:111px}@media (prefers-color-scheme:dark){#iconContainer{background-color:var(--md-background-color)}cr-icon{--iron-icon-fill-color:var(--google-grey-500)}}`]);
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function getHtml() {
    return html `<!--_html_template_start_-->
<div id="outerContainer">
  <div id="profileCardContainer">
    <div id="avatarContainer">
      <img class="profile-avatar" alt="" src="${this.profileState_.avatarIcon}">
      <div id="iconContainer"
          ?hidden="${!this.profileState_.avatarBadge.length}">
        <cr-icon icon="${this.profileState_.avatarBadge}"></cr-icon>
      </div>
    </div>
    <div id="profileName" class="profile-card-info prominent-text">
      ${this.profileState_.localProfileName}
    </div>
    <div id="gaiaName" class="profile-card-info secondary-text">
      ${this.profileState_.gaiaName}
    </div>
  </div>
  <div id="titleContainer">
    <h1 class="title">$i18n{profileSwitchTitle}</h1>
    <div class="subtitle">$i18n{profileSwitchSubtitle}</div>
  </div>
  <div id="actionContainer">
    <cr-button id="cancelButton" @click="${this.onCancelClick_}">
      $i18n{cancel}
    </cr-button>
    <cr-button id="switchButton" class="action-button"
        ?disabled="${!this.isProfileStateInitialized_}"
        @click="${this.onSwitchClick_}">
      $i18n{switchButtonLabel}
    </cr-button>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class ProfileSwitchElement extends CrLitElement {
    static get is() {
        return 'profile-switch';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            profileState_: { type: Object },
            isProfileStateInitialized_: { type: Boolean },
        };
    }
    #profileState__accessor_storage = createDummyProfileState();
    get profileState_() { return this.#profileState__accessor_storage; }
    set profileState_(value) { this.#profileState__accessor_storage = value; }
    #isProfileStateInitialized__accessor_storage = false;
    get isProfileStateInitialized_() { return this.#isProfileStateInitialized__accessor_storage; }
    set isProfileStateInitialized_(value) { this.#isProfileStateInitialized__accessor_storage = value; }
    manageProfilesBrowserProxy_ = ManageProfilesBrowserProxyImpl.getInstance();
    firstUpdated() {
        const params = new URLSearchParams(window.location.search);
        const profileSwitchPath = params.get('profileSwitchPath');
        assert(profileSwitchPath !== null, '`profileSwitchPath` param is not set');
        this.manageProfilesBrowserProxy_.getProfileState(profileSwitchPath)
            .then(profileState => {
            this.profileState_ = profileState;
            this.isProfileStateInitialized_ = true;
        });
    }
    onCancelClick_() {
        this.manageProfilesBrowserProxy_.cancelProfileSwitch();
    }
    onSwitchClick_() {
        this.manageProfilesBrowserProxy_.confirmProfileSwitch(this.profileState_.profilePath);
    }
}
customElements.define(ProfileSwitchElement.is, ProfileSwitchElement);

export { ProfileSwitchElement, ProfileTypeChoiceElement };
//# sourceMappingURL=lazy_load.rollup.js.map
