// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '/strings.m.js';
import '//resources/cr_elements/cr_button/cr_button.js';
import { I18nMixinLit } from '//resources/cr_elements/i18n_mixin_lit.js';
import { assert } from '//resources/js/assert.js';
import { loadTimeData } from '//resources/js/load_time_data.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { HistorySyncOptInBrowserProxyImpl } from './browser_proxy.js';
import { LaunchContext, ScreenMode } from './history_sync_optin.mojom-webui.js';
import { getCss } from './history_sync_optin_app.css.js';
import { getHtml } from './history_sync_optin_app.html.js';
const HistorySyncOptinAppElementBase = I18nMixinLit(CrLitElement);
export class HistorySyncOptinAppElement extends HistorySyncOptinAppElementBase {
    static get is() {
        return 'history-sync-optin-app';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            accountImageSrc_: { type: String },
            isModal_: {
                type: Boolean,
                reflect: true,
            },
            screenMode_: { type: ScreenMode },
        };
    }
    #accountImageSrc__accessor_storage = loadTimeData.getString('accountPictureUrl');
    get accountImageSrc_() { return this.#accountImageSrc__accessor_storage; }
    set accountImageSrc_(value) { this.#accountImageSrc__accessor_storage = value; }
    launchContext_ = loadTimeData.getInteger('launchContext');
    #isModal__accessor_storage = this.isLaunchContext_(LaunchContext.kModal);
    get isModal_() { return this.#isModal__accessor_storage; }
    set isModal_(value) { this.#isModal__accessor_storage = value; }
    historySyncOptInBrowserProxy_ = HistorySyncOptInBrowserProxyImpl.getInstance();
    onAccountInfoDataReceivedListenerId_ = null;
    onScreenModeDataReceivedListenerId_ = null;
    #screenMode__accessor_storage = ScreenMode.kPending;
    get screenMode_() { return this.#screenMode__accessor_storage; }
    set screenMode_(value) { this.#screenMode__accessor_storage = value; }
    connectedCallback() {
        super.connectedCallback();
        this.onAccountInfoDataReceivedListenerId_ =
            this.historySyncOptInBrowserProxy_.callbackRouter.sendAccountInfo
                .addListener(this.handleAccountInfoChanged_.bind(this));
        this.onScreenModeDataReceivedListenerId_ =
            this.historySyncOptInBrowserProxy_.callbackRouter.sendScreenMode
                .addListener(this.handleScreenModeChanged_.bind(this));
        this.historySyncOptInBrowserProxy_.handler.requestAccountInfo();
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        assert(this.onAccountInfoDataReceivedListenerId_);
        this.historySyncOptInBrowserProxy_.callbackRouter.removeListener(this.onAccountInfoDataReceivedListenerId_);
        this.onAccountInfoDataReceivedListenerId_ = null;
        assert(this.onScreenModeDataReceivedListenerId_);
        this.historySyncOptInBrowserProxy_.callbackRouter.removeListener(this.onScreenModeDataReceivedListenerId_);
        this.onScreenModeDataReceivedListenerId_ = null;
    }
    onReject_() {
        this.historySyncOptInBrowserProxy_.handler.reject();
    }
    onAccept_() {
        this.historySyncOptInBrowserProxy_.handler.accept();
    }
    isLaunchContext_(launchContext) {
        return this.launchContext_ === launchContext;
    }
    getRejectButtonClass_() {
        switch (this.screenMode_) {
            case ScreenMode.kPending:
                return 'visibility-hidden';
            case ScreenMode.kUnrestricted:
                return 'tonal-button';
            default:
                // Default cr-button styling, appears equally weighted with the other
                // button.
                return '';
        }
    }
    getAcceptButtonClass_() {
        switch (this.screenMode_) {
            case ScreenMode.kPending:
                return 'visibility-hidden';
            case ScreenMode.kUnrestricted:
                return 'action-button';
            default:
                // Default cr-button styling, appears equally weighted with the other
                // button.
                return '';
        }
    }
    handleAccountInfoChanged_(accountInfo) {
        this.accountImageSrc_ = accountInfo.accountImageSrc.url;
    }
    handleScreenModeChanged_(screenMode) {
        this.screenMode_ = screenMode;
    }
}
customElements.define(HistorySyncOptinAppElement.is, HistorySyncOptinAppElement);
