// chrome/browser/ui/webui/signin/history_sync_optin/history_sync_optin.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const LaunchContextSpec = { $: mojo.internal.Enum() };
export var LaunchContext;
(function (LaunchContext) {
    LaunchContext[LaunchContext["MIN_VALUE"] = 0] = "MIN_VALUE";
    LaunchContext[LaunchContext["MAX_VALUE"] = 1] = "MAX_VALUE";
    LaunchContext[LaunchContext["kWindow"] = 0] = "kWindow";
    LaunchContext[LaunchContext["kModal"] = 1] = "kModal";
})(LaunchContext || (LaunchContext = {}));
export const ScreenModeSpec = { $: mojo.internal.Enum() };
export var ScreenMode;
(function (ScreenMode) {
    ScreenMode[ScreenMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    ScreenMode[ScreenMode["MAX_VALUE"] = 3] = "MAX_VALUE";
    ScreenMode[ScreenMode["kPending"] = 0] = "kPending";
    ScreenMode[ScreenMode["kRestricted"] = 1] = "kRestricted";
    ScreenMode[ScreenMode["kUnrestricted"] = 2] = "kUnrestricted";
    ScreenMode[ScreenMode["kDeadlined"] = 3] = "kDeadlined";
})(ScreenMode || (ScreenMode = {}));
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'history_sync_optin.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createHistorySyncOptinHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsSpec.$, null, impl.createHistorySyncOptinHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "history_sync_optin.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createHistorySyncOptinHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createHistorySyncOptinHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsSpec.$, null, this.createHistorySyncOptinHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'history_sync_optin.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    accept() {
        this.proxy.sendMessage(0, PageHandler_Accept_ParamsSpec.$, null, [], false);
    }
    reject() {
        this.proxy.sendMessage(1, PageHandler_Reject_ParamsSpec.$, null, [], false);
    }
    requestAccountInfo() {
        this.proxy.sendMessage(2, PageHandler_RequestAccountInfo_ParamsSpec.$, null, [], false);
    }
    updateDialogHeight(height) {
        this.proxy.sendMessage(3, PageHandler_UpdateDialogHeight_ParamsSpec.$, null, [
            height
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_Accept_ParamsSpec.$, null, impl.accept.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_Reject_ParamsSpec.$, null, impl.reject.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_RequestAccountInfo_ParamsSpec.$, null, impl.requestAccountInfo.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_UpdateDialogHeight_ParamsSpec.$, null, impl.updateDialogHeight.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "history_sync_optin.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    accept;
    reject;
    requestAccountInfo;
    updateDialogHeight;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.accept =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_Accept_ParamsSpec.$, null, this.accept.createReceiverHandler(false /* expectsResponse */), false);
        this.reject =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_Reject_ParamsSpec.$, null, this.reject.createReceiverHandler(false /* expectsResponse */), false);
        this.requestAccountInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_RequestAccountInfo_ParamsSpec.$, null, this.requestAccountInfo.createReceiverHandler(false /* expectsResponse */), false);
        this.updateDialogHeight =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_UpdateDialogHeight_ParamsSpec.$, null, this.updateDialogHeight.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'history_sync_optin.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    sendAccountInfo(accountInfo) {
        this.proxy.sendMessage(0, Page_SendAccountInfo_ParamsSpec.$, null, [
            accountInfo
        ], false);
    }
    sendScreenMode(screenMode) {
        this.proxy.sendMessage(1, Page_SendScreenMode_ParamsSpec.$, null, [
            screenMode
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_SendAccountInfo_ParamsSpec.$, null, impl.sendAccountInfo.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_SendScreenMode_ParamsSpec.$, null, impl.sendScreenMode.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "history_sync_optin.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    sendAccountInfo;
    sendScreenMode;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.sendAccountInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_SendAccountInfo_ParamsSpec.$, null, this.sendAccountInfo.createReceiverHandler(false /* expectsResponse */), false);
        this.sendScreenMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_SendScreenMode_ParamsSpec.$, null, this.sendScreenMode.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const AccountInfoSpec = { $: {} };
export const PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsSpec = { $: {} };
export const PageHandler_Accept_ParamsSpec = { $: {} };
export const PageHandler_Reject_ParamsSpec = { $: {} };
export const PageHandler_RequestAccountInfo_ParamsSpec = { $: {} };
export const PageHandler_UpdateDialogHeight_ParamsSpec = { $: {} };
export const Page_SendAccountInfo_ParamsSpec = { $: {} };
export const Page_SendScreenMode_ParamsSpec = { $: {} };
mojo.internal.Struct(AccountInfoSpec.$, 'AccountInfo', [
    mojo.internal.StructField('accountImageSrc', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandlerFactory_CreateHistorySyncOptinHandler_ParamsSpec.$, 'PageHandlerFactory_CreateHistorySyncOptinHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_Accept_ParamsSpec.$, 'PageHandler_Accept_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_Reject_ParamsSpec.$, 'PageHandler_Reject_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_RequestAccountInfo_ParamsSpec.$, 'PageHandler_RequestAccountInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_UpdateDialogHeight_ParamsSpec.$, 'PageHandler_UpdateDialogHeight_Params', [
    mojo.internal.StructField('height', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_SendAccountInfo_ParamsSpec.$, 'Page_SendAccountInfo_Params', [
    mojo.internal.StructField('accountInfo', 0, 0, AccountInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_SendScreenMode_ParamsSpec.$, 'Page_SendScreenMode_Params', [
    mojo.internal.StructField('screenMode', 0, 0, ScreenModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
