import { VoiceClientSideStatusCode } from './voice_language_conversions.js';
import type { VoicePackStatus } from './voice_language_conversions.js';
export interface VoiceLanguageListener {
    onEnabledLangsChange(): void;
    onAvailableVoicesChange(): void;
    onCurrentVoiceChange(): void;
}
export declare class VoiceLanguageController {
    private notificationManager_;
    private model_;
    private speech_;
    private listeners_;
    private speechExtensionResponseCallbackHandle_?;
    constructor();
    addListener(listener: VoiceLanguageListener): void;
    getCurrentLanguage(): string;
    getCurrentVoice(): SpeechSynthesisVoice | null;
    private setCurrentVoice_;
    getEnabledLangs(): string[];
    getAvailableLangs(): string[];
    private setAvailableVoices_;
    getAvailableVoices(): SpeechSynthesisVoice[];
    hasAvailableVoices(): boolean;
    isVoiceAvailable(voice?: SpeechSynthesisVoice): boolean;
    private onEngineMightBeReady_;
    onTtsEngineInstalled(): void;
    onVoicesChanged(): void;
    private installLanguageIfPossible_;
    private autoSwitchVoice_;
    setUserPreferredVoice(selectedVoice: SpeechSynthesisVoice): void;
    onPageLanguageChanged(): void;
    onLanguageToggle(toggledLanguage: string): void;
    private setUserPreferredVoiceFromPrefs_;
    private updateAutoSelectedVoiceToNaturalVoice_;
    private updateUnavailableVoiceToDefaultVoice_;
    getCurrentVoiceOrDefault(): SpeechSynthesisVoice | null;
    onLanguageUnavailableError(): void;
    onVoiceUnavailableError(): void;
    private disableLangIfNoVoices_;
    private disableLang_;
    enableLang(lang?: string): void;
    isLangEnabled(lang: string): boolean;
    private enableNowAvailableLangs_;
    private isLangAvailable_;
    restoreFromPrefs(): void;
    private refreshAvailableVoices_;
    getDisplayNamesForLocaleCodes(): {
        [locale: string]: string;
    };
    getServerStatus(lang: string): VoicePackStatus | null;
    setServerStatus(lang: string, status: VoicePackStatus): void;
    getLocalStatus(lang: string): VoiceClientSideStatusCode | null;
    setLocalStatus(lang: string, status: VoiceClientSideStatusCode): void;
    updateLanguageStatus(lang: string, status: string): void;
    private updateApplicationState_;
    private triggerInstall_;
    private requestInstall_;
    private uninstall_;
    stopWaitingForSpeechExtension(): void;
    private installEnabledLangs_;
    private requestInfo_;
    private forceInstallRequest_;
    private setSpeechExtensionResponseTimeout_;
    private alignPreferencesWithEnabledLangs_;
    private getAvailableVoicesForLang_;
    private currentVoiceIsUserChosen_;
    private getDefaultVoice_;
    static getInstance(): VoiceLanguageController;
    static setInstance(obj: VoiceLanguageController): void;
}
