/**
 * @fileoverview A helper object used by the "Your saved info" page
 * to interact with the browser to obtain data types counters
 */
export interface PasswordCount {
    passwordCount: number;
    passkeyCount: number;
}
export interface SavedInfoHandlerProxy {
    /**
     * Get the number of passwords and passkeys.
     */
    getPasswordCount(): Promise<PasswordCount>;
    /**
     * Get the number of loyalty cards.
     */
    getLoyaltyCardsCount(): Promise<number | undefined>;
}
export declare class SavedInfoHandlerImpl implements SavedInfoHandlerProxy {
    getPasswordCount(): Promise<any>;
    getLoyaltyCardsCount(): Promise<any>;
    static getInstance(): SavedInfoHandlerProxy;
    static setInstance(obj: SavedInfoHandlerProxy): void;
}
