import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/cr_elements/icons.html.js';
import '../icons.html.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { FocusConfig } from '../focus_config.js';
import type { Route } from '../router.js';
import { ContentSettingsTypes } from '../site_settings/constants.js';
export interface CategoryListItem {
    route: Route;
    id: ContentSettingsTypes;
    label: string;
    icon?: string;
    enabledLabel?: string;
    disabledLabel?: string;
    otherLabel?: string;
    shouldShow?: () => boolean;
}
export declare function defaultSettingLabel(setting: string, enabled: string, disabled: string, other?: string): string;
declare const SettingsSiteSettingsListElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../base_mixin.js").BaseMixinInterface) & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface);
declare class SettingsSiteSettingsListElement extends SettingsSiteSettingsListElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        categoryList: ArrayConstructor;
        categoryMap_: {
            type: MapConstructor;
            computed: string;
        };
    };
    static get observers(): string[];
    categoryList: CategoryListItem[];
    private categoryMap_;
    private browserProxy_;
    getFocusConfig(): FocusConfig;
    private computeCategoryMap;
    ready(): void;
    /**
     * @param category The category to refresh (fetch current value + update UI)
     * @return A promise firing after the label has been updated.
     */
    private refreshDefaultValueLabel_;
    /**
     * Updates the DOM for the given |category| to display a label that
     * corresponds to the given |setting|.
     */
    private updateDefaultValueLabel_;
    /**
     * Update the cookies link row label when the cookies setting description
     * changes.
     */
    private updateCookiesLabel_;
    /**
     * Update the geolocation link row label when the geolocation setting
     * description changes.
     */
    private updateLocationLabel_;
    /**
     * Update the notifications link row label when the notifications setting
     * description changes.
     */
    private updateNotificationsLabel_;
    /**
     * Update the site data link row label when the default cookies content
     * setting changes.
     */
    private updateSiteDataLabel_;
    /**
     * Update the third-party cookies link row label when the pref changes.
     */
    private updateThirdPartyCookiesLabel_;
    private updateOfferWritingHelpLabel_;
    private onClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-site-settings-list': SettingsSiteSettingsListElement;
    }
}
export {};
