import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="settings-shared">:host{padding-inline-end:4px}.settings-row{flex:1}cr-policy-pref-indicator::part(tooltip){clip:rect(0 0 0 0);height:1px;overflow:hidden;width:1px}
    </style>
    <div class="list-item" focus-row-container>
      <div class="settings-row" role="row"
          aria-label="[[computeAriaLabel_(model)]]">
        <div role="gridcell" class="settings-row" on-click="onOriginClick_"
            id="originArea" aria-label="[[computeAriaLabel_(model)]]"
            actionable$="[[allowNavigateToSiteDetail_]]">
          <site-favicon url="[[computeFaviconOrigin_(model)]]"></site-favicon>
          <div class="middle no-min-width">
            <div class="text-elide">
              <span class="url-directionality">
                [[computeDisplayName_(model)]]</span>
            </div>
            <!-- This div must not contain extra whitespace. -->
            <div class="secondary"
                id="siteDescription">[[computeSiteDescription_(model)]]</div>
          </div>

          <template is="dom-if" if="[[allowNavigateToSiteDetail_]]">
            <cr-icon-button class="subpage-arrow"
                aria-label$="[[computeViewButtonAriaLabel_(model)]]"
                aria-describedby="siteDescription"
                aria-roledescription="$i18n{subpageArrowRoleDescription}"
                focus-type="site-details" focus-row-control></cr-icon-button>
            <div class="separator"></div>
          </template>
        </div>
        <template is="dom-if" if="[[showPolicyPrefIndicator_]]">
          <div role="gridcell">
            <cr-policy-pref-indicator pref="[[model]]"
                on-mouseenter="onShowTooltip_"
                on-focus="onShowTooltip_" focus-row-control focus-type="policy">
            </cr-policy-pref-indicator>
          </div>
        </template>
        <template is="dom-if" if="[[model.incognito]]">
          <div role="gridcell">
            <cr-tooltip-icon id="incognitoTooltip"
                icon-aria-label="$i18n{incognitoSiteExceptionDesc}"
                icon-class="settings20:incognito"
                focus-row-control focus-type="incognito"
                on-mouseenter="onShowIncognitoTooltip_"
                on-focus="onShowIncognitoTooltip_"></cr-tooltip-icon>
          </div>
        </template>
        <template is="dom-if"
            if="[[shouldShowResetButton_(model, readOnlyList)]]">
          <div role="gridcell">
            <cr-icon-button id="resetSite" class="icon-delete-gray"
                on-click="onResetButtonClick_"
                aria-label="[[computeRemoveButtonAriaLabel_(model)]]"
                focus-row-control focus-type="reset"></cr-icon-button>
          </div>
        </template>
        <template is="dom-if"
            if="[[shouldShowActionMenu_(model, readOnlyList)]]">
          <div role="gridcell">
            <cr-icon-button id="actionMenuButton" class="icon-more-vert"
                on-click="onShowActionMenuClick_"
                title$="[[getActionMenuButtonLabel_(model)]]"
                focus-row-control focus-type="menu"></cr-icon-button>
          </div>
        </template>
      </div>
    </div>
<!--_html_template_end_-->`;
}
