/**
 * @fileoverview
 * 'settings-category-default-radio-group' is the polymer element for showing
 * a certain category under Site Settings.
 */
import '../settings_shared.css.js';
import '../controls/settings_radio_group.js';
import '../privacy_page/collapse_radio_button.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsRadioGroupElement } from '../controls/settings_radio_group.js';
import type { SettingsCollapseRadioButtonElement } from '../privacy_page/collapse_radio_button.js';
/**
 * Selected content setting radio option.
 */
export declare enum SiteContentRadioSetting {
    DISABLED = 0,
    ENABLED = 1
}
export interface SettingsCategoryDefaultRadioGroupElement {
    $: {
        enabledRadioOption: SettingsCollapseRadioButtonElement;
        disabledRadioOption: SettingsCollapseRadioButtonElement;
        settingsCategoryDefaultRadioGroup: SettingsRadioGroupElement;
    };
}
declare const SettingsCategoryDefaultRadioGroupElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("./site_settings_mixin.js").SiteSettingsMixinInterface);
export declare class SettingsCategoryDefaultRadioGroupElement extends SettingsCategoryDefaultRadioGroupElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        header: {
            type: StringConstructor;
            value(): string;
        };
        description: {
            type: StringConstructor;
            value(): string;
        };
        allowOptionLabel: StringConstructor;
        allowOptionSubLabel: StringConstructor;
        allowOptionIcon: StringConstructor;
        blockOptionLabel: StringConstructor;
        blockOptionSubLabel: StringConstructor;
        blockOptionIcon: StringConstructor;
        siteContentRadioSettingEnum_: {
            type: ObjectConstructor;
            value: typeof SiteContentRadioSetting;
        };
        /**
         * Preference object used to keep track of the selected content setting
         * option.
         */
        pref_: {
            type: ObjectConstructor;
            value(): {
                type: chrome.settingsPrivate.PrefType;
                value: number;
            };
        };
    };
    static get observers(): string[];
    header: string;
    description: string;
    allowOptionLabel: string;
    allowOptionSubLabel: string;
    allowOptionIcon: string;
    blockOptionLabel: string;
    blockOptionSubLabel: string;
    blockOptionIcon: string;
    private pref_;
    selected: boolean;
    ready(): void;
    private getAllowOptionForCategory_;
    private getEnabledButtonClass_;
    private getDisabledButtonClass_;
    /**
     * A handler for changing the default permission value for a content type.
     * This is also called during page setup after we get the default state.
     */
    private onSelectedChanged_;
    /**
     * Update the pref values from the content settings.
     * @param update The updated content setting value.
     */
    private updatePref_;
    private onCategoryChanged_;
    private get categoryEnabled_();
    /**
     * Check if the category is popups and the user is logged in guest mode.
     * Users in guest mode are not allowed to modify pop-ups content setting.
     */
    private isRadioGroupDisabled_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-category-default-radio-group': SettingsCategoryDefaultRadioGroupElement;
    }
}
export {};
