/**
 * @fileoverview
 * 'settings-safety-hub-notification-permissions-module' is the module in Safety
 * Hub page that show the origins sending a lot of notifications.
 */
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_tooltip/cr_tooltip.js';
import '../settings_shared.css.js';
import '../i18n_setup.js';
import '../icons.html.js';
import type { CrActionMenuElement } from 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrToastElement } from 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route } from '../router.js';
import type { SettingsSafetyHubModuleElement } from './safety_hub_module.js';
export interface SettingsSafetyHubNotificationPermissionsModuleElement {
    $: {
        actionMenu: CrActionMenuElement;
        blockAllButton: HTMLElement;
        bulkUndoButton: HTMLElement;
        headerActionMenu: CrActionMenuElement;
        ignore: HTMLElement;
        module: SettingsSafetyHubModuleElement;
        reset: HTMLElement;
        toastUndoButton: HTMLElement;
        undoNotification: HTMLElement;
        undoToast: CrToastElement;
    };
}
declare const SettingsSafetyHubNotificationPermissionsModuleElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../site_settings/site_settings_mixin.js").SiteSettingsMixinInterface) & (new (...args: any[]) => import("../base_mixin.js").BaseMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../tooltip_mixin.js").TooltipMixinInterface);
export declare class SettingsSafetyHubNotificationPermissionsModuleElement extends SettingsSafetyHubNotificationPermissionsModuleElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        headerString_: StringConstructor;
        subheaderString_: StringConstructor;
        headerIconString_: StringConstructor;
        toastText_: StringConstructor;
        lastUserAction_: StringConstructor;
        lastOrigins_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        sites_: {
            type: ArrayConstructor;
            value: null;
        };
        shouldShowCompletionInfo_: {
            type: BooleanConstructor;
            computed: string;
        };
    };
    static get observers(): string[];
    private headerString_;
    private subheaderString_;
    private headerIconString_;
    private toastText_;
    private sites_;
    private shouldShowCompletionInfo_;
    private lastOrigins_;
    private renderedOrigins_;
    private lastUserAction_;
    private eventTracker_;
    private browserProxy_;
    private metricsBrowserProxy_;
    connectedCallback(): Promise<void>;
    disconnectedCallback(): void;
    currentRouteChanged(currentRoute: Route): void;
    private onNotificationPermissionListChanged_;
    private setHeaderToCompletionState_;
    private onSitesChanged_;
    /** Clears all the changes made by a previous action. */
    private resetValues_;
    /** Sets all the values needed for an action. */
    private setValues_;
    private onBlockClick_;
    private onMoreActionClick_;
    private onIgnoreClick_;
    private onResetClick_;
    private onBlockAllClick_;
    private onUndoClick_;
    private onHeaderMoreActionClick_;
    private onGoToSettingsClick_;
    private updateUndoNotificationText_;
    private showUndoToast_;
    private undoLastAction_;
    private onKeyDown_;
    /** Show info that review is completed when there are no permissions left. */
    private computeShouldShowCompletionInfo_;
    private getIgnoreAriaLabelForOrigins;
    private getResetAriaLabelForOrigins;
    private showUndoTooltip_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-safety-hub-notification-permissions-module': SettingsSafetyHubNotificationPermissionsModuleElement;
    }
}
export {};
