/**
 * @fileoverview
 * 'settings-reset-profile-banner' is the banner shown for prompting the user to
 * clear profile settings.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsResetProfileBannerElement {
    $: {
        dialog: CrDialogElement;
        ok: HTMLElement;
        reset: HTMLElement;
    };
}
export declare class SettingsResetProfileBannerElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    connectedCallback(): void;
    private onOkClick_;
    private onCancel_;
    private onResetClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-reset-profile-banner': SettingsResetProfileBannerElement;
    }
}
