/**
 * @fileoverview
 * 'privacy-sandbox-interest-item' is the custom element to show a topics or
 * fledge interest in the privacy sandbox.
 */
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { PrivacySandboxInterest } from './privacy_sandbox_browser_proxy.js';
declare const PrivacySandboxInterestItemElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class PrivacySandboxInterestItemElement extends PrivacySandboxInterestItemElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        interest: ObjectConstructor;
    };
    interest: PrivacySandboxInterest;
    private getDisplayString_;
    private getButtonLabel_;
    private getButtonAriaLabel_;
    private onInterestChanged_;
}
declare global {
    interface HTMLElementTagNameMap {
        'privacy-sandbox-interest-item': PrivacySandboxInterestItemElement;
    }
}
export {};
