/**
 * @fileoverview 'settings-security-keys-reset-dialog' is a dialog for
 * triggering factory resets of security keys.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js';
import 'chrome://resources/cr_elements/cr_spinner_style.css.js';
import '../../settings_shared.css.js';
import '../../i18n_setup.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export declare enum ResetDialogPage {
    INITIAL = "initial",
    NO_RESET = "noReset",
    RESET_FAILED = "resetFailed",
    RESET_CONFIRM = "resetConfirm",
    RESET_SUCCESS = "resetSuccess",
    RESET_NOT_ALLOWED = "resetNotAllowed"
}
export interface SettingsSecurityKeysResetDialogElement {
    $: {
        button: HTMLElement;
        dialog: CrDialogElement;
        resetFailed: HTMLElement;
    };
}
declare const SettingsSecurityKeysResetDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SettingsSecurityKeysResetDialogElement extends SettingsSecurityKeysResetDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * A CTAP error code for when the specific error was not recognised.
         */
        errorCode_: NumberConstructor;
        /**
         * True iff the process has completed, successfully or otherwise.
         */
        complete_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * The id of an element on the page that is currently shown.
         */
        shown_: {
            type: StringConstructor;
            value: ResetDialogPage;
        };
        title_: StringConstructor;
    };
    private errorCode_;
    private complete_;
    private shown_;
    private title_;
    private browserProxy_;
    connectedCallback(): void;
    private closeDialog_;
    private finish_;
    private onIronSelect_;
    /**
     * @param code CTAP error code.
     * @return Contents of the error string that may be displayed to the user.
     *     Used automatically by Polymer.
     */
    private resetFailed_;
    /**
     * @param complete Whether the dialog process is complete.
     * @return The label of the dialog button. Used automatically by Polymer.
     */
    private closeText_;
    /**
     * @param complete Whether the dialog process is complete.
     * @return The class of the dialog button. Used automatically by Polymer.
     */
    private maybeActionButton_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-security-keys-reset-dialog': SettingsSecurityKeysResetDialogElement;
    }
}
export {};
