/**
 * @fileoverview 'settings-security-keys-credential-management-dialog' is a
 * dialog for viewing and erasing credentials stored on a security key.
 */
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js';
import 'chrome://resources/cr_elements/cr_spinner_style.css.js';
import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/polymer/v3_0/iron-list/iron-list.js';
import '../../settings_shared.css.js';
import '../../site_favicon.js';
import '../../i18n_setup.js';
import './security_keys_pin_field.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrInputElement } from 'chrome://resources/cr_elements/cr_input/cr_input.js';
import type { IronListElement } from 'chrome://resources/polymer/v3_0/iron-list/iron-list.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsSecurityKeysPinFieldElement } from './security_keys_pin_field.js';
export declare enum CredentialManagementDialogPage {
    INITIAL = "initial",
    PIN_PROMPT = "pinPrompt",
    PIN_ERROR = "pinError",
    CREDENTIALS = "credentials",
    EDIT = "edit",
    ERROR = "error",
    CONFIRM = "confirm"
}
export interface SettingsSecurityKeysCredentialManagementDialogElement {
    $: {
        cancelButton: CrButtonElement;
        confirm: HTMLElement;
        confirmButton: CrButtonElement;
        credentialList: IronListElement;
        dialog: CrDialogElement;
        displayNameInput: CrInputElement;
        edit: HTMLElement;
        error: HTMLElement;
        pin: SettingsSecurityKeysPinFieldElement;
        pinError: HTMLElement;
        userNameInput: CrInputElement;
    };
}
declare const SettingsSecurityKeysCredentialManagementDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsSecurityKeysCredentialManagementDialogElement extends SettingsSecurityKeysCredentialManagementDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * The ID of the element currently shown in the dialog.
         */
        dialogPage_: {
            type: StringConstructor;
            value: CredentialManagementDialogPage;
            observer: string;
        };
        dialogTitle_: StringConstructor;
        /**
         * The list of credentials displayed in the dialog.
         */
        credentials_: {
            type: ArrayConstructor;
            notify: boolean;
        };
        /**
         * The message displayed on the "error" dialog page.
         */
        errorMsg_: StringConstructor;
        cancelButtonVisible_: BooleanConstructor;
        closeButtonVisible_: BooleanConstructor;
        confirmButtonDisabled_: BooleanConstructor;
        confirmButtonLabel_: StringConstructor;
        confirmButtonVisible_: BooleanConstructor;
        confirmMsg_: StringConstructor;
        credentialIdToDelete_: StringConstructor;
        displayNameInputError_: StringConstructor;
        editingCredential_: ObjectConstructor;
        editButtonVisible_: BooleanConstructor;
        minPinLength_: NumberConstructor;
        newDisplayName_: StringConstructor;
        newUsername_: StringConstructor;
        userNameInputError_: StringConstructor;
    };
    private cancelButtonVisible_;
    private closeButtonVisible_;
    private confirmButtonDisabled_;
    private confirmButtonLabel_;
    private confirmButtonVisible_;
    private confirmMsg_;
    private credentialIdToDelete_;
    private credentials_;
    private dialogPage_;
    private dialogTitle_;
    private displayNameInputError_;
    private editingCredential_;
    private editButtonVisible_;
    private errorMsg_;
    private minPinLength_;
    private newDisplayName_;
    private newUsername_;
    private userNameInputError_;
    private browserProxy_;
    private showSetPINButton_;
    connectedCallback(): void;
    private onPinError_;
    private onError_;
    private submitPin_;
    private onCredentials_;
    private dialogPageChanged_;
    private onConfirmButtonClick_;
    private onCancelButtonClick_;
    private onDialogClosed_;
    private close_;
    private isEmpty_;
    private onIronSelect_;
    private onDeleteButtonClick_;
    private deleteCredential_;
    private validateInput_;
    private onUpdateButtonClick_;
    private updateUserInformation_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-security-keys-credential-management-dialog': SettingsSecurityKeysCredentialManagementDialogElement;
    }
}
export {};
