import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare const StepIndicatorBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export interface StepIndicatorModel {
    active: number;
    total: number;
}
export declare class StepIndicator extends StepIndicatorBase {
    static get is(): string;
    static get properties(): {
        /**
         * An Object with 'active' and 'total' members, indicating the active dot
         * index and the total number of dots.
         */
        model: ObjectConstructor;
        /**
         * An array with length equal to the number of dots, for use by
         * dom-repeat. The contents of the array are unused.
         */
        dots_: {
            type: ArrayConstructor;
            computed: string;
        };
    };
    model: StepIndicatorModel;
    private dots_;
    /**
     * @return the screenreader label for this element.
     */
    private computeA11yLabel_;
    private computeDots_;
    /**
     * Returns a class for the dot at `index`, which will highlight the dot at the
     * active index.
     */
    private getActiveClass_;
    static get template(): HTMLTemplateElement;
}
export {};
