/**
 * @fileoverview
 * 'privacy-guide-safe-browsing-fragment' is the fragment in a privacy
 * guide card that contains the safe browsing settings and their descriptions.
 */
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import '/shared/settings/prefs/prefs.js';
import './privacy_guide_fragment_shared.css.js';
import '../../controls/settings_radio_group.js';
import '../../icons.html.js';
import '../../privacy_page/collapse_radio_button.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { SafeBrowsingSetting } from '../../privacy_page/security_page.js';
declare const PrivacyGuideSafeBrowsingFragmentBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class PrivacyGuideSafeBrowsingFragmentElement extends PrivacyGuideSafeBrowsingFragmentBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Valid safe browsing states.
         */
        safeBrowsingSettingEnum_: {
            type: ObjectConstructor;
            value: typeof SafeBrowsingSetting;
        };
        enableHashPrefixRealTimeLookups_: {
            type: BooleanConstructor;
            value(): boolean;
        };
    };
    private metricsBrowserProxy_;
    private startStateEnhanced_;
    private enableHashPrefixRealTimeLookups_;
    ready(): void;
    focus(): void;
    private onViewEnterStart_;
    private onViewExitFinish_;
    private onSafeBrowsingEnhancedClick_;
    private onSafeBrowsingStandardClick_;
    private getSafeBrowsingStandardSubLabel_;
    private getStandardProtectionFeatureDescription2_;
    private getStandardProtectionPrivacyDescription1_;
}
declare global {
    interface HTMLElementTagNameMap {
        'privacy-guide-safe-browsing-fragment': PrivacyGuideSafeBrowsingFragmentElement;
    }
}
export {};
