/**
 * @fileoverview
 * 'personalization-options' contains several toggles related to
 * personalizations.
 */
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_toggle/cr_toggle.js';
import '/shared/settings/prefs/prefs.js';
import '../controls/settings_toggle_button.js';
import '../people_page/signout_dialog.js';
import 'chrome://resources/cr_elements/md_select.css.js';
import '../relaunch_confirmation_dialog.js';
import '../settings_shared.css.js';
import '//resources/cr_elements/cr_toast/cr_toast.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import type { CrLinkRowElement } from '//resources/cr_elements/cr_link_row/cr_link_row.js';
import type { CrToastElement } from '//resources/cr_elements/cr_toast/cr_toast.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SyncStatus } from '/shared/settings/people_page/sync_browser_proxy.js';
import { ChromeSigninUserChoice } from '/shared/settings/people_page/sync_browser_proxy.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
export interface SettingsPersonalizationOptionsElement {
    $: {
        toast: CrToastElement;
        signinAllowedToggle: SettingsToggleButtonElement;
        metricsReportingControl: SettingsToggleButtonElement;
        metricsReportingLink: CrLinkRowElement;
        urlCollectionToggle: SettingsToggleButtonElement;
        chromeSigninUserChoiceSelection: HTMLSelectElement;
        chromeSigninUserChoiceToast: CrToastElement;
    };
}
declare const SettingsPersonalizationOptionsElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("//resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../relaunch_mixin.js").RelaunchMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_components/help_bubble/help_bubble_mixin.js").HelpBubbleMixinInterface);
export declare class SettingsPersonalizationOptionsElement extends SettingsPersonalizationOptionsElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        syncStatus: ObjectConstructor;
        showSearchAggregatorSuggest_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        searchAggregatorSuggestFakePref_: {
            type: ObjectConstructor;
            value(): {
                key: string;
                type: chrome.settingsPrivate.PrefType;
                value: boolean;
                enforcement: chrome.settingsPrivate.Enforcement;
                controlledBy: chrome.settingsPrivate.ControlledBy;
            };
        };
        showSignoutDialog_: BooleanConstructor;
        syncFirstSetupInProgress_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
        signinAvailable_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        chromeSigninUserChoiceInfo_: {
            type: ObjectConstructor;
            value: null;
        };
        /** Expose ChromeSigninUserChoice enum to HTML bindings. */
        chromeSigninUserChoiceEnum_: {
            type: ObjectConstructor;
            value: typeof ChromeSigninUserChoice;
        };
    };
    syncStatus: SyncStatus;
    private showSearchAggregatorSuggest_;
    private searchAggregatorSuggestFakePref_;
    private showSignoutDialog_;
    private syncFirstSetupInProgress_;
    private signinAvailable_;
    private chromeSigninUserChoiceInfo_;
    private browserProxy_;
    private syncBrowserProxy_;
    private computeSyncFirstSetupInProgress_;
    private showPriceEmailNotificationsToggle_;
    private getPriceEmailNotificationsPrefDesc_;
    ready(): void;
    private showSearchSuggestToggle_;
    private onSigninAllowedChange_;
    private onSignoutDialogClosed_;
    private onRestartClick_;
    private setChromeSigninUserChoiceInfo_;
    private onChromeSigninChoiceSelectionChanged_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-personalization-options': SettingsPersonalizationOptionsElement;
    }
}
export {};
