import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js';
import 'chrome://resources/cr_elements/cr_tabs/cr_tabs.js';
import './exception_add_input.js';
import './exception_current_sites_list.js';
import type { PrefsMixinInterface } from '/shared/settings/prefs/prefs_mixin.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrTabsElement } from 'chrome://resources/cr_elements/cr_tabs/cr_tabs.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { ExceptionAddInputElement } from './exception_add_input.js';
import type { ExceptionCurrentSitesListElement } from './exception_current_sites_list.js';
export declare enum ExceptionAddDialogTabs {
    CURRENT_SITES = 0,
    MANUAL = 1
}
export interface ExceptionTabbedAddDialogElement {
    $: {
        actionButton: CrButtonElement;
        cancelButton: CrButtonElement;
        dialog: CrDialogElement;
        input: ExceptionAddInputElement;
        list: ExceptionCurrentSitesListElement;
        tabs: CrTabsElement;
    };
}
type Constructor<T> = new (...args: any[]) => T;
declare const ExceptionTabbedAddDialogElementBase: Constructor<PrefsMixinInterface & PolymerElement>;
export declare class ExceptionTabbedAddDialogElement extends ExceptionTabbedAddDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        selectedTab_: {
            type: NumberConstructor;
            value: number;
        };
        tabNames_: {
            type: ArrayConstructor;
            value: string[];
        };
        submitDisabledList_: BooleanConstructor;
        submitDisabledManual_: BooleanConstructor;
    };
    private selectedTab_;
    private tabNames_;
    private submitDisabledList_;
    private submitDisabledManual_;
    private onSelectedTabChanged_;
    private onSitesPopulated_;
    private isAddCurrentSitesTabSelected_;
    private onCancelClick_;
    private onSubmitClick_;
    private isSubmitDisabled_;
}
declare global {
    interface HTMLElementTagNameMap {
        'tab-discard-exception-tabbed-add-dialog': ExceptionTabbedAddDialogElement;
    }
}
export {};
