import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import 'chrome://resources/cr_elements/cr_expand_button/cr_expand_button.js';
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import 'chrome://resources/cr_elements/cr_tooltip/cr_tooltip.js';
import '../../settings_shared.css.js';
import './exception_edit_dialog.js';
import './exception_entry.js';
import './exception_tabbed_add_dialog.js';
import type { PrefsMixinInterface } from '/shared/settings/prefs/prefs_mixin.js';
import type { CrActionMenuElement } from 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrCollapseElement } from 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import type { CrExpandButtonElement } from 'chrome://resources/cr_elements/cr_expand_button/cr_expand_button.js';
import type { CrLazyRenderElement } from 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import type { CrTooltipElement } from 'chrome://resources/cr_elements/cr_tooltip/cr_tooltip.js';
import type { ListPropertyUpdateMixinInterface } from 'chrome://resources/cr_elements/list_property_update_mixin.js';
import type { DomRepeat } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { TooltipMixinInterface } from '../../tooltip_mixin.js';
export declare const TAB_DISCARD_EXCEPTIONS_OVERFLOW_SIZE: number;
export interface ExceptionListElement {
    $: {
        addButton: CrButtonElement;
        collapse: CrCollapseElement;
        expandButton: CrExpandButtonElement;
        list: DomRepeat;
        overflowList: DomRepeat;
        menu: CrLazyRenderElement<CrActionMenuElement>;
        noSitesAdded: HTMLElement;
        tooltip: CrTooltipElement;
    };
}
type Constructor<T> = new (...args: any[]) => T;
declare const ExceptionListElementBase: Constructor<TooltipMixinInterface & ListPropertyUpdateMixinInterface & PrefsMixinInterface & PolymerElement>;
export declare class ExceptionListElement extends ExceptionListElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        siteList_: {
            type: ArrayConstructor;
            value: never[];
        };
        overflowSiteListExpanded: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * Rule corresponding to the last more actions menu opened. Indicates to
         * this element and its dialog which rule to edit or if a new one should
         * be added.
         */
        selectedRule_: {
            type: StringConstructor;
            value: string;
        };
        showTabbedAddDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showEditDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        tooltipText_: StringConstructor;
    };
    static get observers(): string[];
    private siteList_;
    private overflowSiteListExpanded;
    private selectedRule_;
    private showTabbedAddDialog_;
    private showEditDialog_;
    private tooltipText_;
    private metricsProxy_;
    private hasSites_;
    private hasOverflowSites_;
    private getSiteList_;
    private getOverflowSiteList_;
    private onAddClick_;
    private onMenuClick_;
    private onEditClick_;
    private onDeleteClick_;
    private onTabbedAddDialogClose_;
    private onEditDialogClose_;
    private onPrefsChanged_;
    /**
     * Need to use common tooltip since the tooltip in the entry is cut off from
     * the iron-list.
     */
    private onShowTooltip_;
}
declare global {
    interface HTMLElementTagNameMap {
        'tab-discard-exception-list': ExceptionListElement;
    }
}
export {};
