export declare enum PerformanceFeedbackCategory {
    NOTIFICATIONS = "performance_notifications",
    TABS = "performance_tabs",
    BATTERY = "performance_battery",
    SPEED = "performance_speed"
}
export interface PerformanceBrowserProxy {
    getCurrentOpenSites(): Promise<string[]>;
    getDeviceHasBattery(): Promise<boolean>;
    openFeedbackDialog(categoryTag: PerformanceFeedbackCategory): void;
    validateTabDiscardExceptionRule(rule: string): Promise<boolean>;
}
export declare class PerformanceBrowserProxyImpl implements PerformanceBrowserProxy {
    getCurrentOpenSites(): Promise<any>;
    getDeviceHasBattery(): Promise<any>;
    openFeedbackDialog(categoryTag: PerformanceFeedbackCategory): void;
    validateTabDiscardExceptionRule(rule: string): Promise<any>;
    static getInstance(): PerformanceBrowserProxy;
    static setInstance(obj: PerformanceBrowserProxy): void;
}
