import '//resources/js/util.js';
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_collapse/cr_collapse.js';
import '//resources/cr_elements/cr_dialog/cr_dialog.js';
import '//resources/cr_elements/cr_input/cr_input.js';
import '//resources/cr_elements/cr_link_row/cr_link_row.js';
import '//resources/cr_elements/icons.html.js';
import '//resources/cr_elements/cr_shared_style.css.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import '//resources/cr_elements/cr_expand_button/cr_expand_button.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '//resources/cr_elements/cr_toast/cr_toast.js';
import './sync_encryption_options.js';
import '../privacy_page/personalization_options.js';
import '../settings_page/settings_subpage.js';
import '../settings_shared.css.js';
import '../settings_vars.css.js';
import './sync_account_control.js';
import type { CrCollapseElement } from '//resources/cr_elements/cr_collapse/cr_collapse.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SyncPrefs } from '/shared/settings/people_page/sync_browser_proxy.js';
import { PageStatus } from '/shared/settings/people_page/sync_browser_proxy.js';
import type { FocusConfig } from '../focus_config.js';
import type { Route } from '../router.js';
export interface SettingsSyncPageElement {
    $: {
        encryptionCollapse: CrCollapseElement;
    };
}
/**
 * @fileoverview
 * 'settings-sync-page' is the settings page containing sync settings.
 */
declare const SettingsSyncPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("//resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsSyncPageElement extends SettingsSyncPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Preferences state.
         */
        prefs: {
            type: ObjectConstructor;
            notify: boolean;
        };
        focusConfig: {
            type: ObjectConstructor;
            observer: string;
        };
        pageStatusEnum_: {
            type: ObjectConstructor;
            value: typeof PageStatus;
            readOnly: boolean;
        };
        /**
         * The current page status. Defaults to |CONFIGURE| such that the
         * searching algorithm can search useful content when the page is not
         * visible to the user.
         */
        pageStatus_: {
            type: StringConstructor;
            value: PageStatus;
        };
        /**
         * The current sync preferences, supplied by SyncBrowserProxy.
         */
        syncPrefs: ObjectConstructor;
        syncStatus_: ObjectConstructor;
        dataEncrypted_: {
            type: BooleanConstructor;
            computed: string;
        };
        encryptionExpanded_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /** If true, override |encryptionExpanded_| to be true. */
        forceEncryptionExpanded: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * The existing passphrase input field value.
         */
        existingPassphrase_: {
            type: StringConstructor;
            value: string;
        };
        showExistingPassphraseBelowAccount_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
        signedIn_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
        syncDisabledByAdmin_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
        syncSectionDisabled_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
        showSetupCancelDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        enterPassphraseLabel_: {
            type: StringConstructor;
            computed: string;
        };
        existingPassphraseLabel_: {
            type: StringConstructor;
            computed: string;
        };
        enableLinkedServicesSetting_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        isEeaChoiceCountry_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        personalizationCollapseExpanded_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    static get observers(): string[];
    prefs: {
        [key: string]: any;
    };
    focusConfig: FocusConfig;
    private pageStatus_;
    syncPrefs?: SyncPrefs;
    private syncStatus_;
    private dataEncrypted_;
    private encryptionExpanded_;
    forceEncryptionExpanded: boolean;
    private existingPassphrase_;
    private showExistingPassphraseBelowAccount_;
    private signedIn_;
    private syncDisabledByAdmin_;
    private syncSectionDisabled_;
    private enableLinkedServicesSetting_;
    private isEeaChoiceCountry_;
    private personalizationCollapseExpanded_;
    private showSetupCancelDialog_;
    private enterPassphraseLabel_;
    private existingPassphraseLabel_;
    private metricsBrowserProxy_;
    private syncBrowserProxy_;
    private collapsibleSectionsInitialized_;
    private didAbort_;
    private setupCancelConfirmed_;
    private beforeunloadCallback_;
    private unloadCallback_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    private onSyncStatusChanged_;
    private computeSignedIn_;
    private computeSyncSectionDisabled_;
    private computeSyncDisabledByAdmin_;
    private onFocusConfigChange_;
    private onSetupCancelDialogBack_;
    private onSetupCancelDialogConfirm_;
    private onSetupCancelDialogClose_;
    private shouldShowSyncPage_;
    currentRouteChanged(newRoute: Route, oldRoute?: Route): void;
    private isStatus_;
    private onNavigateToPage_;
    private onNavigateAwayFromPage_;
    /**
     * Handler for when the sync preferences are updated.
     */
    private handleSyncPrefsChanged_;
    private onActivityControlsClick_;
    private onLinkedServicesClick_;
    private onSyncDashboardLinkClick_;
    private computeDataEncrypted_;
    private computeEnterPassphraseLabel_;
    private computeExistingPassphraseLabel_;
    /**
     * Whether the encryption dropdown should be expanded by default.
     */
    private expandEncryptionIfNeeded_;
    private onResetSyncClick_;
    /**
     * Sends the user-entered existing password to re-enable sync.
     */
    private onSubmitExistingPassphraseClick_;
    private onPassphraseChanged_;
    private computePageStatusAfterPassphraseChange_;
    /**
     * Called when the page status updates.
     */
    private handlePageStatusChanged_;
    private onLearnMoreClick_;
    private shouldShowSyncAccountControl_;
    private computeShowExistingPassphraseBelowAccount_;
    private onSyncAdvancedClick_;
    /**
     * @param e The event passed from settings-sync-account-control.
     */
    private onSyncSetupDone_;
    /**
     * Focuses the passphrase input element if it is available and the page is
     * visible.
     */
    private focusPassphraseInput_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-sync-page': SettingsSyncPageElement;
    }
}
export {};
