// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { sendWithPromise } from 'chrome://resources/js/cr.js';
export class GlicBrowserProxyImpl {
    setGlicOsLauncherEnabled(enabled) {
        chrome.send('setGlicOsLauncherEnabled', [enabled]);
    }
    getGlicShortcut() {
        return sendWithPromise('getGlicShortcut');
    }
    setGlicShortcut(shortcut) {
        return sendWithPromise('setGlicShortcut', shortcut);
    }
    getGlicFocusToggleShortcut() {
        return sendWithPromise('getGlicFocusToggleShortcut');
    }
    setGlicFocusToggleShortcut(shortcut) {
        return sendWithPromise('setGlicFocusToggleShortcut', shortcut);
    }
    setShortcutSuspensionState(shouldSuspend) {
        chrome.send('setShortcutSuspensionState', [shouldSuspend]);
    }
    getDisallowedByAdmin() {
        return sendWithPromise('getGlicDisallowedByAdmin');
    }
    static getInstance() {
        return instance || (instance = new GlicBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
