/**
 * @fileoverview 'settings-passwords-deletion-dialog' is a dialog that is
 * optionally shown inside settings-clear-browsing-data-dialog after deleting
 * passwords. It informs the user that not all password deletions were completed
 * successfully.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import '../settings_shared.css.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsPasswordsDeletionDialogElement {
    $: {
        dialog: CrDialogElement;
    };
}
export declare class SettingsPasswordsDeletionDialogElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    /** Click handler for the "OK" button. */
    private onOkClick_;
}
