/**
 * @fileoverview 'settings-clear-browsing-data-dialog-v2' allows the user to
 * delete browsing data that has been cached by Chromium.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_spinner_style.css.js';
import '../controls/settings_checkbox.js';
import '../settings_shared.css.js';
import './clear_browsing_data_account_indicator.js';
import './clear_browsing_data_time_picker.js';
import './history_deletion_dialog.js';
import './other_google_data_dialog.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrLinkRowElement } from 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route } from '../router.js';
import { BrowsingDataType } from './clear_browsing_data_browser_proxy.js';
import type { SettingsClearBrowsingDataTimePicker } from './clear_browsing_data_time_picker.js';
export interface SettingsClearBrowsingDataDialogV2Element {
    $: {
        cancelButton: CrButtonElement;
        deleteButton: CrButtonElement;
        deleteBrowsingDataDialog: CrDialogElement;
        deletingDataAlert: HTMLElement;
        manageOtherGoogleDataRow: CrLinkRowElement;
        moreOptionsList: HTMLElement;
        showMoreButton: CrButtonElement;
        spinner: HTMLElement;
        timePicker: SettingsClearBrowsingDataTimePicker;
    };
}
export declare function getDataTypePrefName(datatypes: BrowsingDataType): "browser.clear_data.browsing_history" | "browser.clear_data.cache" | "browser.clear_data.cookies" | "browser.clear_data.form_data" | "browser.clear_data.site_settings" | "browser.clear_data.download_history" | "browser.clear_data.hosted_apps_data";
declare const SettingsClearBrowsingDataDialogV2ElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface);
export declare class SettingsClearBrowsingDataDialogV2Element extends SettingsClearBrowsingDataDialogV2ElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        dataTypesExpanded_: {
            type: BooleanConstructor;
            value: boolean;
        };
        deleteButtonLabel_: {
            type: StringConstructor;
            value: string;
            computed: string;
        };
        deletingDataAlertString_: {
            type: StringConstructor;
            value: string;
        };
        isDeletionInProgress_: {
            type: BooleanConstructor;
            value: boolean;
        };
        isNoDatatypeSelected_: {
            type: BooleanConstructor;
            value: boolean;
        };
        isGoogleDse_: {
            type: BooleanConstructor;
            value: boolean;
        };
        otherGoogleDataRowLabel_: {
            type: StringConstructor;
            computed: string;
        };
        otherGoogleDataRowSubLabel_: {
            type: StringConstructor;
            computed: string;
        };
        showHistoryDeletionDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showOtherGoogleDataDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        expandedBrowsingDataTypeOptionsList_: ArrayConstructor;
        moreBrowsingDataTypeOptionsList_: ArrayConstructor;
        syncStatus_: {
            type: ObjectConstructor;
            observer: string;
        };
    };
    private dataTypesExpanded_;
    private deleteButtonLabel_;
    private deletingDataAlertString_;
    private isDeletionInProgress_;
    private isNoDatatypeSelected_;
    private isGoogleDse_;
    private otherGoogleDataRowLabel_;
    private otherGoogleDataRowSubLabel_;
    private showHistoryDeletionDialog_;
    private showOtherGoogleDataDialog_;
    private expandedBrowsingDataTypeOptionsList_;
    private moreBrowsingDataTypeOptionsList_;
    private syncStatus_;
    private clearBrowsingDataBrowserProxy_;
    private syncBrowserProxy_;
    private metricsBrowserProxy_;
    ready(): void;
    private updateDseStatus_;
    private handleSyncStatus_;
    private onSyncStatusChanged_;
    connectedCallback(): void;
    currentRouteChanged(currentRoute: Route): void;
    private setUpDataTypeOptionLists_;
    /**
     * Updates the text of a browsing data counter corresponding to the given
     * preference.
     * @param prefName Browsing data type deletion preference.
     * @param text The text with which to update the counter.
     */
    private updateCounterText_;
    private isSignedIn_;
    private shouldDataTypeBeExpanded_;
    private computeDeleteButtonLabel_;
    private computeOtherGoogleDataRowLabel_;
    private computeOtherGoogleDataRowSubLabel_;
    private onTimePeriodChanged_;
    private onCancelClick_;
    /**
     * Triggers browsing data deletion on the selected DataTypes and within the
     * selected TimePeriod.
     */
    private onDeleteBrowsingDataClick_;
    private showDeletionConfirmationToast_;
    private getSelectedDataTypes_;
    private updateDeleteButtonState_;
    private onShowMoreClick_;
    private shouldHideShowMoreButton_;
    private shouldDisableDeleteButton_;
    private onHistoryDeletionDialogClose_;
    private onManageOtherGoogleDataRowClick_;
    private setFocusOutlineToVisible_;
    private onOtherGoogleDataDialogClose_;
    private onCheckboxSubLabelLinkClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-clear-browsing-data-dialog-v2': SettingsClearBrowsingDataDialogV2Element;
    }
}
export {};
