/**
 * @fileoverview 'settings-virtual-card-unenroll-dialog' is the dialog that is
 * shown when the action menu button "Remove virtual card" is clicked. It
 * requests user confirmation before unenrolling a card from the virtual card
 * feature.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../settings_shared.css.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare global {
    interface HTMLElementEventMap {
        'unenroll-virtual-card': CustomEvent<string>;
    }
}
export interface SettingsVirtualCardUnenrollDialogElement {
    $: {
        dialog: CrDialogElement;
        confirmButton: CrButtonElement;
    };
}
export declare class SettingsVirtualCardUnenrollDialogElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * The credit card being unenrolled from the virtual cards.
         */
        creditCard: ObjectConstructor;
    };
    creditCard: chrome.autofillPrivate.CreditCardEntry;
    close(): void;
    private onCancelButtonClick_;
    private onConfirmButtonClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-virtual-card-unenroll-dialog': SettingsVirtualCardUnenrollDialogElement;
    }
}
