/**
 * @fileoverview 'settings-payments-section' is the section containing saved
 * credit cards for use in autofill and payments APIs.
 */
import '/shared/settings/prefs/prefs.js';
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import '../settings_page/settings_subpage.js';
import '../settings_shared.css.js';
import '../controls/settings_toggle_button.js';
import './credit_card_edit_dialog.js';
import './iban_edit_dialog.js';
import '../simple_confirmation_dialog.js';
import './passwords_shared.css.js';
import './payments_list.js';
import './virtual_card_unenroll_dialog.js';
import type { CrActionMenuElement } from 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrLazyRenderElement } from 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
import type { SettingsPaymentsListElement } from './payments_list.js';
type DotsCardMenuiClickEvent = CustomEvent<{
    creditCard: chrome.autofillPrivate.CreditCardEntry;
    anchorElement: HTMLElement;
}>;
type RemoteCardMenuClickEvent = CustomEvent<{
    creditCard: chrome.autofillPrivate.CreditCardEntry;
    anchorElement: HTMLElement;
}>;
declare global {
    interface HTMLElementEventMap {
        'dots-card-menu-click': DotsCardMenuiClickEvent;
        'remote-card-menu-click': RemoteCardMenuClickEvent;
    }
}
export interface SettingsPaymentsSectionElement {
    $: {
        autofillCreditCardToggle: SettingsToggleButtonElement;
        canMakePaymentToggle: SettingsToggleButtonElement;
        creditCardSharedMenu: CrActionMenuElement;
        ibanSharedActionMenu: CrLazyRenderElement<CrActionMenuElement>;
        manageLink: HTMLElement;
        mandatoryAuthToggle: SettingsToggleButtonElement;
        menuEditCreditCard: HTMLElement;
        menuRemoveCreditCard: HTMLElement;
        menuAddVirtualCard: HTMLElement;
        menuRemoveVirtualCard: HTMLElement;
        paymentsList: SettingsPaymentsListElement;
    };
}
declare const SettingsPaymentsSectionElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsPaymentsSectionElement extends SettingsPaymentsSectionElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        prefs: ObjectConstructor;
        /**
         * Whether we should hide the "close" button to get to the previous page.
         */
        hideCloseButton: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * An array of all saved credit cards.
         */
        creditCards: {
            type: ArrayConstructor;
            value: () => never[];
        };
        /**
         * An array of all saved IBANs.
         */
        ibans: {
            type: ArrayConstructor;
            value: () => never[];
        };
        /**
         * An array of all saved pay over time issuers.
         */
        payOverTimeIssuers: {
            type: ArrayConstructor;
            value: () => never[];
        };
        /**
         * Whether IBAN is supported in Settings page.
         */
        showIbanSettingsEnabled_: {
            type: BooleanConstructor;
            value(): boolean;
            readOnly: boolean;
        };
        /**
         * The model for any credit card-related action menus or dialogs.
         */
        activeCreditCard_: ObjectConstructor;
        /**
         * The model for any IBAN-related action menus or dialogs.
         */
        activeIban_: ObjectConstructor;
        showCreditCardDialog_: BooleanConstructor;
        showIbanDialog_: BooleanConstructor;
        showLocalCreditCardRemoveConfirmationDialog_: BooleanConstructor;
        showLocalIbanRemoveConfirmationDialog_: BooleanConstructor;
        showVirtualCardUnenrollDialog_: BooleanConstructor;
        showBulkRemoveCvcConfirmationDialog_: BooleanConstructor;
        /**
         * Checks if we can use device authentication to authenticate the user.
         */
        deviceAuthAvailable_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        /**
         * Checks if CVC storage is available based on the feature flag.
         */
        cvcStorageAvailable_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        /**
         * Checks if a card benefits feature flag is enabled.
         */
        cardBenefitsFlagEnabled_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        /**
         * Sublabel for the card benefits toggle. The sublabel text also includes
         * a link to learn about the card benefits.
         */
        cardBenefitsSublabel_: {
            type: StringConstructor;
            value(): string;
        };
        /**
         * Checks if pay over time should be shown from the settings page.
         */
        shouldShowPayOverTimeSettings_: {
            type: BooleanConstructor;
            value(): boolean;
            readOnly: boolean;
        };
        /**
         * Sublabel for the pay over time toggle. The sublabel text also includes
         * a link to learn about pay over time.
         */
        payOverTimeSublabel_: {
            type: StringConstructor;
            value(): string;
        };
    };
    hideCloseButton: boolean;
    prefs: {
        [key: string]: any;
    };
    creditCards: chrome.autofillPrivate.CreditCardEntry[];
    ibans: chrome.autofillPrivate.IbanEntry[];
    payOverTimeIssuers: chrome.autofillPrivate.PayOverTimeIssuerEntry[];
    private showIbanSettingsEnabled_;
    private activeCreditCard_;
    private activeIban_;
    private showCreditCardDialog_;
    private showIbanDialog_;
    private showLocalCreditCardRemoveConfirmationDialog_;
    private showLocalIbanRemoveConfirmationDialog_;
    private showVirtualCardUnenrollDialog_;
    private deviceAuthAvailable_;
    private cvcStorageAvailable_;
    private showBulkRemoveCvcConfirmationDialog_;
    private paymentsManager_;
    private setPersonalDataListener_;
    private cardBenefitsFlagEnabled_;
    private cardBenefitsSublabel_;
    private shouldShowPayOverTimeSettings_;
    private payOverTimeSublabel_;
    connectedCallback(): void;
    disconnectedCallback(): void;
    private setCreditCards_;
    /**
     * Returns true if IBAN should be shown from settings page.
     * TODO(crbug.com/40234941): Add additional check (starter country-list, or
     * the saved-pref-boolean on if the user has submitted an IBAN form).
     */
    private shouldShowIbanSettings_;
    /**
     * Opens the dropdown menu to add a credit/debit card or IBAN.
     */
    private onAddPaymentMethodClick_;
    /**
     * Opens the credit card action menu.
     */
    private onCreditCardDotsMenuClick_;
    /**
     * Opens the IBAN action menu.
     */
    private onDotsIbanMenuClick_;
    /**
     * Handles clicking on the "Add credit card" button.
     */
    private onAddCreditCardClick_;
    private onCreditCardDialogClose_;
    /**
     * Handles clicking on the add "IBAN" option.
     */
    private onAddIbanClick_;
    private onIbanDialogClose_;
    /**
     * Handles clicking on the "Edit" credit card button.
     */
    private onMenuEditCreditCardClick_;
    private onRemoteEditCreditCardClick_;
    private onRemoteCreditCardUrlClick_;
    private onRemoteEditIbanMenuClick_;
    private onLocalCreditCardRemoveConfirmationDialogClose_;
    /**
     * Handles clicking on the "Remove" credit card button.
     */
    private onMenuRemoveCreditCardClick_;
    /**
     * Handles clicking on the "Edit" IBAN button.
     */
    private onMenuEditIbanClick_;
    private onLocalIbanRemoveConfirmationDialogClose_;
    /**
     * Handles clicking on the "Remove" IBAN button.
     */
    private onMenuRemoveIbanClick_;
    private onMenuAddVirtualCardClick_;
    private onMenuRemoveVirtualCardClick_;
    private onVirtualCardUnenrollDialogClose_;
    /**
     * Records changes made to the "Allow sites to check if you have payment
     * methods saved" setting to a histogram.
     */
    private onCanMakePaymentChange_;
    /**
     * Listens for the save-credit-card event, and calls the private API.
     */
    private saveCreditCard_;
    private onSaveIban_;
    private getMenuEditCardText_;
    private shouldShowAddVirtualCardButton_;
    private shouldShowRemoveVirtualCardButton_;
    /**
     * Listens for the unenroll-virtual-card event, and calls the private API.
     */
    private unenrollVirtualCard_;
    /**
     * Checks if we should disable the mandatory reauth toggle.
     * This method checks that one of the following conditions are met:
     * 1) Pref autofill.credit_card_enabled is false
     * 2) There is no support for device authentication
     * Under any of these circumstances, we should display a disabled mandatory
     * re-auth toggle to the user.
     */
    private shouldDisableAuthToggle_;
    private focusHeaderControls_;
    /**
     * Checks for user auth before flipping the mandatory auth toggle.
     */
    private onMandatoryAuthToggleChange_;
    /**
     * Method to handle the clicking of bulk delete all the CVCs.
     */
    private onBulkRemoveCvcClick_;
    /**
     * Method to bulk delete all the CVCs present on the local DB.
     */
    private onShowBulkRemoveCvcConfirmationDialogClose_;
    /**
     * Method to return the correct sublabel for the cvc storage toggle.
     * If any card from the list has a cvc, the sublabel with bulk delete
     * hyperlink is returned else return the regular sublabel.
     * @returns Cvc storage toggle sublabel string.
     */
    private getCvcStorageSublabel_;
    /**
     * Opens an article to learn about card benefits when the card benefits toggle
     * sublabel link is clicked.
     */
    private onCardBenefitsSublabelLinkClick_;
    /**
     * Get the CVC storage toggle aria label for a11y voice readers.
     * @returns CVC storage aria label.
     */
    private getCvcStorageAriaLabel_;
    /**
     * Opens an article to learn about pay over time when the pay over time
     * toggle sublabel link is clicked.
     */
    private onPayOverTimeSublabelLinkClick_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-payments-section': SettingsPaymentsSectionElement;
    }
}
export {};
