/**
 * @fileoverview 'settings-iban-edit-dialog' is the dialog that allows
 * editing or creating an IBAN entry.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import '../settings_shared.css.js';
import '../settings_vars.css.js';
import '../i18n_setup.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrInputElement } from 'chrome://resources/cr_elements/cr_input/cr_input.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
/**
 * Enum of possible states for the iban. An iban is valid if it has the correct
 * structure, matches the length for its country code, and passes a checksum.
 * Otherwise, it is invalid and we may show an error to the user in cases where
 * we are certain they have entered an invalid iban (i.e. vs still typing).
 */
declare enum IbanValidationState {
    VALID = "valid",
    INVALID_NO_ERROR = "invalid-no-error",
    INVALID_WITH_ERROR = "invalid-with-error"
}
declare global {
    interface HTMLElementEventMap {
        'save-iban': CustomEvent<chrome.autofillPrivate.IbanEntry>;
    }
}
export interface SettingsIbanEditDialogElement {
    $: {
        dialog: CrDialogElement;
        valueInput: CrInputElement;
        nicknameInput: CrInputElement;
        cancelButton: CrButtonElement;
        saveButton: CrButtonElement;
    };
}
declare const SettingsIbanEditDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SettingsIbanEditDialogElement extends SettingsIbanEditDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * The IBAN being added or edited. Null means add a new IBAN, otherwise,
         * edit the existing IBAN.
         */
        iban: {
            type: ObjectConstructor;
            value: null;
        };
        /**
         * The actual title that's used for this dialog. Will be context sensitive
         * based on which type of IBAN method is being viewed, and if it is being
         * created or edited.
         */
        title_: StringConstructor;
        /**
         * Backing data for inputs in the dialog, each bound to the corresponding
         * HTML elements.
         *
         * Note that value_ is unsanitized; code should instead use
         * `sanitizedIban_`.
         */
        value_: StringConstructor;
        nickname_: StringConstructor;
        /**
         * A sanitized version of `value_` with whitespace trimmed.
         */
        sanitizedIban_: {
            type: StringConstructor;
            computed: string;
            observer: string;
        };
        /** Whether the current iban field is invalid. */
        ibanValidationState_: {
            type: typeof IbanValidationState;
            value: boolean;
        };
    };
    iban: chrome.autofillPrivate.IbanEntry | null;
    private title_;
    private value_?;
    private nickname_?;
    private sanitizedIban_;
    private ibanValidationState_;
    private paymentsManager_;
    connectedCallback(): void;
    /** Closes the dialog. */
    close(): void;
    /**
     * Handler for clicking the 'cancel' button. Should just dismiss the dialog.
     */
    private onCancelButtonClick_;
    /**
     * Handler for clicking the save button.
     */
    private onIbanSaveButtonClick_;
    private onSanitizedIbanChanged_;
    private onIbanInputBlurred_;
    private showErrorForIban_;
    private sanitizeIban_;
    private computeIbanValidationState_;
    private isValidIban;
    /**
     * @param  nickname of the IBAN, undefined when not set.
     * @return nickname character length.
     */
    private computeNicknameCharCount_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-iban-edit-dialog': SettingsIbanEditDialogElement;
    }
}
export {};
