type AttributeType = chrome.autofillPrivate.AttributeType;
type EntityInstance = chrome.autofillPrivate.EntityInstance;
type EntityInstanceWithLabels = chrome.autofillPrivate.EntityInstanceWithLabels;
type EntityType = chrome.autofillPrivate.EntityType;
export type EntityInstancesChangedListener = (entityInstances: EntityInstanceWithLabels[]) => void;
/**
 * This interface defines the autofill API wrapper that combines entity data
 * manager related methods.
 */
export interface EntityDataManagerProxy {
    /**
     * Adds a new entity instance if it doesn't exist yet. Otherwise, it updates
     * the entity instance.
     */
    addOrUpdateEntityInstance(entityInstance: EntityInstance): void;
    /**
     * Remove the entity instance by its id.
     */
    removeEntityInstance(guid: string): void;
    /**
     * Returns the user's entity instances with labels.
     */
    loadEntityInstances(): Promise<EntityInstanceWithLabels[]>;
    /**
     * Returns the entity instance by its guid.
     */
    getEntityInstanceByGuid(guid: string): Promise<EntityInstance>;
    /**
     * Returns a list of all enabled entity types.
     */
    getAllEntityTypes(): Promise<EntityType[]>;
    /**
     * Returns a list of all attribute types that can be set on an entity
     * instance.
     */
    getAllAttributeTypesForEntityTypeName(entityTypeName: number): Promise<AttributeType[]>;
    /**
     * Adds a listener to changes in the entity instances.
     */
    addEntityInstancesChangedListener(listener: EntityInstancesChangedListener): void;
    /**
     * Removes a listener to changes in the entity instances.
     */
    removeEntityInstancesChangedListener(listener: EntityInstancesChangedListener): void;
    /**
     * Gets the opt-in status for AutofillAi for the current user.
     */
    getOptInStatus(): Promise<boolean>;
    /**
     * Sets the opt-in status for AutofillAi for the current user. Returns whether
     * setting was successful, which more precisely means whether the user is
     * eligible to opt into Autofill AI.
     */
    setOptInStatus(optedIn: boolean): Promise<boolean>;
}
export declare class EntityDataManagerProxyImpl implements EntityDataManagerProxy {
    addOrUpdateEntityInstance(entityInstance: EntityInstance): void;
    removeEntityInstance(guid: string): void;
    loadEntityInstances(): Promise<chrome.autofillPrivate.EntityInstanceWithLabels[]>;
    getEntityInstanceByGuid(guid: string): Promise<chrome.autofillPrivate.EntityInstance>;
    getAllEntityTypes(): Promise<chrome.autofillPrivate.EntityType[]>;
    getAllAttributeTypesForEntityTypeName(entityTypeName: number): Promise<chrome.autofillPrivate.AttributeType[]>;
    addEntityInstancesChangedListener(listener: EntityInstancesChangedListener): void;
    removeEntityInstancesChangedListener(listener: EntityInstancesChangedListener): void;
    getOptInStatus(): Promise<boolean>;
    setOptInStatus(optedIn: boolean): Promise<boolean>;
    static getInstance(): EntityDataManagerProxy;
    static setInstance(obj: EntityDataManagerProxy): void;
}
export {};
