/**
 * @fileoverview 'credit-card-list-entry' is a credit card row to be shown in
 * the settings page.
 */
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import '../settings_shared.css.js';
import './passwords_shared.css.js';
import './screen_reader_only.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare const SettingsCreditCardListEntryElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SettingsCreditCardListEntryElement extends SettingsCreditCardListEntryElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /** A saved credit card. */
        creditCard: ObjectConstructor;
        showNewFopDisplayEnabled_: {
            type: BooleanConstructor;
            value(): boolean;
            readOnly: boolean;
        };
    };
    creditCard: chrome.autofillPrivate.CreditCardEntry;
    private showNewFopDisplayEnabled_;
    get dotsMenu(): HTMLElement | null;
    /**
     * Opens the credit card action menu.
     */
    private onDotsMenuClick_;
    private onRemoteEditClick_;
    private onSummarySublabelTermsLinkClick_;
    private getCardNumberDescription_;
    /**
     * @returns the title for the More Actions button corresponding to the card
     *     which is described by the nickname or the network name and last 4
     *     digits or name. If a card has CVC saved, there will be additional
     *     description to notify of the same.
     */
    private moreActionsTitle_;
    /**
     * Returns true if the new FOP display should be shown.
     */
    private shouldShowNewFopDisplay_;
    /**
     * The card has a product description or a nickname.
     */
    private hasCardIdentifier_;
    /**
     * The 3-dot menu should be shown if the card is not a masked server card or
     * if the card is eligible for virtual card enrollment.
     */
    private showDots_;
    private isVirtualCardEnrollmentEligible_;
    private isVirtualCardEnrolled_;
    private getCardIdentifierAriaLabel_;
    private getSummaryAriaLabel_;
    /**
     * Returns an aria label for the benefits terms link such as "See terms for
     * Amex ending in 0001". If no card description is available, then the
     * default text such as "See terms here" is returned.
     */
    private getBenefitsTermsAriaLabel_;
    private getCardExpiryDate_;
    private getCardSublabelType;
    /**
     * Returns expiration date.
     */
    private getExpirationlabel_;
    /**
     * Returns one of the following sublabels, based on the card's status:
     *   Virtual card enrollment tag
     *   'CVC saved' tag
     *   Benefit tag (Place the benefit tag last because it includes a link to
     *                product terms.)
     * e.g., one of the following:
     *   CVC saved
     *   Card benefits available (terms apply)
     *   CVC saved | Card benefits available (terms apply)
     *   Virtual card turned on
     *   Virtual card turned on | CVC saved
     *   Virtual card turned on | Card benefits available (terms apply)
     *   Virtual card turned on | CVC saved | Card benefits available (terms
     *     apply)
     */
    private getSummarySublabel_;
    private hasSummaryAndBenefitSublabel_;
    private getSummaryAriaSublabel_;
    private shouldShowVirtualCardSecondarySublabel_;
    private shouldShowPaymentsIndicator_;
    private isCardCvcAvailable_;
    private isCardBenefitsProductUrlAvailable_;
    private getCardBenefitsProductUrl_;
    /**
     * When the provided `imageSrc` points toward a processor's default card art,
     * this function returns a string that will scale the image based on the
     * user's screen resolution, otherwise it will return the unmodified
     * `imageSrc`.
     */
    private getCardImage_;
    /**
     * This function returns a string that can be used in a srcset to scale
     * the provided `url` based on the user's screen resolution.
     */
    private getScaledSrcSet_;
}
export {};
