/**
 * @fileoverview 'settings-autofill-entries-list-element' contains configuration
 * options for Autofill AI.
 */
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_icons.css.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '/shared/settings/prefs/prefs.js';
import 'chrome://resources/cr_elements/icons.html.js';
import '../icons.html.js';
import '../settings_shared.css.js';
import '../simple_confirmation_dialog.js';
import './autofill_ai_add_or_edit_dialog.js';
import type { CrActionMenuElement } from 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrLazyRenderElement } from 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsAutofillAiEntriesListElement {
    $: {
        actionMenu: CrLazyRenderElement<CrActionMenuElement>;
        addMenu: CrLazyRenderElement<CrActionMenuElement>;
    };
}
declare const SettingsAutofillAiEntriesListElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsAutofillAiEntriesListElement extends SettingsAutofillAiEntriesListElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
           If a user is not eligible for Autofill with Ai, but they have data
           saved, the code allows them only to edit and delete their data. They
           are not allowed to add new data, or to opt-in or opt-out of Autofill
           with Ai using the toggle at the top of this page.
           If a user is not eligible for Autofill with Ai and they also have no
           data saved, then they cannot access this page at all.
         */
        ineligibleUser: {
            type: BooleanConstructor;
            value(): boolean;
        };
        allowEditing_: {
            type: ObjectConstructor;
            value: boolean;
        };
        /**
           The corresponding `EntityInstance` model for any entity instance
           related action menus or dialogs.
         */
        activeEntityInstance_: {
            type: ObjectConstructor;
            value: null;
        };
        /**
           Complete list of entity types that exist. When the user wants to add a
           new entity instance, this list is displayed.
         */
        completeEntityTypesList_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        /**
           The same dialog can be used for both adding and editing entity
           instances.
         */
        showAddOrEditEntityInstanceDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        addOrEditEntityInstanceDialogTitle_: {
            type: StringConstructor;
            value: string;
        };
        showRemoveEntityInstanceDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        entityInstances_: {
            type: ArrayConstructor;
            value: () => never[];
        };
    };
    static get observers(): string[];
    ineligibleUser: boolean;
    private allowEditing_;
    private activeEntityInstance_;
    private completeEntityTypesList_;
    private showAddOrEditEntityInstanceDialog_;
    private addOrEditEntityInstanceDialogTitle_;
    private showRemoveEntityInstanceDialog_;
    private entityInstances_;
    private entityInstancesChangedListener_;
    private entityDataManager_;
    connectedCallback(): void;
    disconnectedCallback(): void;
    private entityTypesComparator_;
    /**
     * This comparator compares the labels alphabetically, and, in case of
     * equality, the sublabels.
     * This comparator purposefully uses sensitivity 'base', not to differentiate
     * between different capitalization or diacritics.
     */
    private entityInstancesWithLabelsComparator_;
    /**
     * Handles tapping on the "Add" entity instance button.
     */
    private onAddEntityInstanceClick_;
    private onAddEntityInstanceFromDropdownClick_;
    /**
     * Open the action menu.
     */
    private onMoreButtonClick_;
    /**
     * Handles tapping on the "Edit" entity instance button in the action menu.
     */
    private onMenuEditEntityInstanceClick_;
    /**
     * Handles tapping on the "Delete" entity instance button in the action menu.
     */
    private onMenuRemoveEntityInstanceClick_;
    private onAutofillAiAddOrEditDone_;
    private onAddOrEditEntityInstanceDialogClose_;
    private onRemoveEntityInstanceDialogClose_;
    private onAutofillAiPrefChanged_;
    private onRemoteWalletPassesLinkClick_;
    private onOptInStatusChanged_;
    private onSyncStatusChanged_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-autofill-ai-entries-list-element': SettingsAutofillAiEntriesListElement;
    }
}
export {};
