/**
 * @fileoverview 'settings-about-page' contains version and OS related
 * information.
 */
import '/shared/settings/prefs/prefs.js';
import '../relaunch_confirmation_dialog.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsPlugin } from '../settings_main/settings_plugin.js';
import { UpdateStatus } from './about_page_browser_proxy.js';
declare const SettingsAboutPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../relaunch_mixin.js").RelaunchMixinInterface);
export declare class SettingsAboutPageElement extends SettingsAboutPageElementBase implements SettingsPlugin {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        currentUpdateStatusEvent_: {
            type: ObjectConstructor;
            value: {
                message: string;
                progress: number;
                rollback: boolean;
                status: UpdateStatus;
            };
        };
        /**
         * Whether the browser/ChromeOS is managed by their organization
         * through enterprise policies.
         */
        isManaged_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        /**
         * The name of the icon to display in the management card.
         * Should only be read if isManaged_ is true.
         */
        managedByIcon_: {
            type: StringConstructor;
            value(): string;
        };
        obsoleteSystemInfo_: {
            type: ObjectConstructor;
            value(): {
                obsolete: boolean;
                endOfLine: boolean;
            };
        };
        showUpdateStatus_: {
            type: BooleanConstructor;
            value: boolean;
        };
        showButtonContainer_: BooleanConstructor;
        showRelaunch_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    static get observers(): string[];
    private currentUpdateStatusEvent_;
    private isManaged_;
    private managedByIcon_;
    private obsoleteSystemInfo_;
    private showUpdateStatus_;
    private showButtonContainer_;
    private showRelaunch_;
    private aboutBrowserProxy_;
    connectedCallback(): void;
    private getPromoteUpdaterClass_;
    private startListening_;
    private onUpdateStatusChanged_;
    private onLearnMoreClick_;
    private onHelpClick_;
    private onRelaunchClick_;
    private updateShowUpdateStatus_;
    /**
     * Hide the button container if all buttons are hidden, otherwise the
     * container displays an unwanted border (see separator class).
     */
    private updateShowButtonContainer_;
    private updateShowRelaunch_;
    private shouldShowLearnMoreLink_;
    private getUpdateStatusMessage_;
    private getUpdateStatusIcon_;
    private shouldShowThrobber_;
    private checkStatus_;
    private onManagementPageClick_;
    private onProductLogoClick_;
    private shouldShowIcons_;
    searchContents(query: string): Promise<{
        canceled: boolean;
        matchCount: number;
        wasClearSearch: boolean;
    }>;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-about-page': SettingsAboutPageElement;
    }
}
export {};
