import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">:host{padding:0 var(--cr-section-padding)}.row-aligned{align-items:center;display:flex}#toggleButton{min-height:var(--cr-section-min-height)}.site-representation{display:flex}.second-line{margin-top:0.1em;min-height:1.54em}.data-unit{direction:ltr;unicode-bidi:isolate}.list-frame{padding-inline-end:0}.origin-link{overflow:hidden}.spacing{padding-inline-start:1ch}
    </style>
    <div id="collapseParent" focus-row-container>
      <div class$="list-item [[getClassForIndex_(listIndex)]]">
        <div id="toggleButton" class="start row-aligned two-line text-elide"
            on-click="onSiteEntryClick_" actionable aria-expanded="false">
          <site-favicon url="[[getSiteGroupIcon_(siteGroup)]]"></site-favicon>
          <div class="middle text-elide" id="displayName">
            <div class="site-representation">
              <span class="url-directionality text-elide">
                [[displayName_]]
              </span>
              <span class="secondary"
                  hidden$="[[!siteGroupScheme_(siteGroup)]]">
                &nbsp;$i18nPolymer{siteSettingsSiteRepresentationSeparator}&nbsp;
              </span>
              <span class="secondary"
                  hidden$="[[!siteGroupScheme_(siteGroup)]]">
                [[siteGroupScheme_(siteGroup)]]
              </span>
            </div>
            <div class="second-line secondary">
              <span class="data-unit">[[overallUsageString_]]</span>
              <span id="cookies" hidden$="[[!siteGroup.numCookies]]">
                &middot; [[cookieString_]]
              </span>
              <span id="rwsMembership" hidden$=
                  "[[!isRwsMember_(siteGroup.rwsOwner, isRwsFiltered)]]">
                &middot; [[rwsMembershipLabel_]]
              </span>
              <span id="extensionIdDescription"
                  hidden$="[[!isExtension_(siteGroup)]]">
                &middot; [[extensionIdDescription_(siteGroup)]]
              </span>
            </div>
          </div>
          <template is="dom-if" restamp if="[[shouldShowPolicyPrefIndicator_(
                            siteGroup.rwsEnterpriseManaged)]]">
            <cr-policy-pref-indicator
                id="rwsPolicy" pref="[[rwsEnterprisePref_]]"
                icon-aria-label="[[label]]"
                focus-row-control focus-type="policy">
            </cr-policy-pref-indicator>
          </template>
          <cr-icon-button id="expandIcon" class="icon-expand-more"
              hidden$="[[!grouped_(siteGroup)]]" aria-label$="[[displayName_]]"
              aria-describedby="displayName" aria-expanded="false"
              focus-row-control focus-type="expand"></cr-icon-button>
          <cr-icon-button class="subpage-arrow"
              hidden$="[[grouped_(siteGroup)]]"
              aria-label$="[[getSubpageLabel_(siteGroup.displayName)]]"
              aria-roledescription="$i18n{subpageArrowRoleDescription}"
              focus-row-control focus-type="show-detail"></cr-icon-button>
        </div>
        <div class="row-aligned">
          <template is="dom-if" if=
              "[[shouldShowOverflowMenu(siteGroup.rwsOwner, isRwsFiltered)]]">
            <div class="separator"></div>
            <cr-icon-button class="icon-more-vert"
                id="rwsOverflowMenuButton"
                title="$i18n{moreActions}"
                on-click="showOverflowMenu_"
                focus-row-control focus-type="more-actions"
                aria-label$="[[getMoreActionsLabel_(siteGroup)]]">
            </cr-icon-button>
          </template>
          <template is="dom-if" if=
              "[[!shouldShowOverflowMenu(siteGroup.rwsOwner, isRwsFiltered)]]">
            <div class="separator"></div>
            <cr-icon-button class="icon-delete-gray" id="removeSiteButton"
                title$=
                  "[[i18n('siteSettingsCookieRemoveSite', displayName_)]]"
                on-click="onRemove_" focus-row-control focus-type="remove">
            </cr-icon-button>
          </template>
        </div>
      </div>

      <cr-lazy-render id="originList">
        <template>
          <cr-collapse id="collapseChild" no-animation>
            <div class="list-frame">
              <template is="dom-repeat" items="[[siteGroup.origins]]">
                <div class="list-item hr">
                  <div class="start row-aligned list-item origin-link"
                       on-click="onOriginClick_"
                       actionable$="[[!item.isPartitioned]]">
                    <site-favicon url="[[item.origin]]"></site-favicon>
                    <div class="site-representation middle text-elide">
                      <span id="originSiteRepresentation"
                          class="url-directionality text-elide">
                        [[originRepresentation(item.origin)]]
                      </span>
                      <span class="secondary"
                          hidden$="[[!originScheme_(item)]]">
                        &nbsp;
                        $i18nPolymer{siteSettingsSiteRepresentationSeparator}
                        &nbsp;
                      </span>
                      <span class="secondary"
                          hidden$="[[!originScheme_(item)]]">
                        [[originScheme_(item)]]
                      </span>
                      <!--Define a spacing span so that when the direction is
                         rtl, the spacing is still showing correctly. This is
                         because the data-unit class is set to be ltr so the
                         padding will be in wrong place if we put padding in
                         that span.-->
                      <span class="spacing" hidden$="[[!item.usage]]"></span>
                      <span class="secondary data-unit"
                            hidden$="[[!item.usage]]">
                        [[originUsagesItem_(originUsages_.*, index)]]
                      </span>
                      <span class="secondary" hidden$="[[!item.numCookies]]">
                          &nbsp;&middot;
                          [[originCookiesItem_(cookiesNum_.*, index)]]
                      </span>
                      <span class="secondary" hidden$="[[!item.isPartitioned]]">
                          &nbsp;&middot;
                          $i18n{siteSettingsSiteEntryPartitionedLabel}
                      </span>
                    </div>
                    <cr-icon-button class="subpage-arrow"
                        hidden$="[[item.isPartitioned]]"
                        aria-label$="[[getOriginSubpageLabel_(item.origin)]]"
                        aria-roledescription=
                            "$i18n{subpageArrowRoleDescription}"
                        focus-row-control focus-type="detailed-sites">
                    </cr-icon-button>
                  </div>
                  <div class="row-aligned">
                    <div class="separator"></div>
                    <cr-icon-button class="icon-delete-gray"
                        id="removeOriginButton"
                        title$="[[getRemoveOriginButtonTitle_(item.origin)]]"
                        data-origin$="[[item.origin]]" data-context="origin"
                        data-partitioned$="[[item.isPartitioned]]"
                        on-click="onRemove_" focus-row-control
                        focus-type="remove">
                    </cr-icon-button>
                  </div>
                </div>
              </template>
            </div>
          </cr-collapse>
      </template>
    </cr-lazy-render>
    </div>
<!--_html_template_end_-->`;
}