import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style"></style>
<settings-subpage page-title="$i18n{adPrivacyPageTitle}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
  <template is="dom-if" if="[[!isPrivacySandboxRestricted_]]">
    <cr-link-row
        id="privacySandboxTopicsLinkRow"
        start-icon="settings20:interests"
        label="$i18n{adPrivacyPageTopicsLinkRowLabel}"
        sub-label="[[computePrivacySandboxTopicsSublabel_(
                      prefs.privacy_sandbox.m1.topics_enabled.value)]]"
        on-click="onPrivacySandboxTopicsClick_"></cr-link-row>
    <cr-link-row
        id="privacySandboxFledgeLinkRow"
        start-icon="settings20:checklist"
        class="hr"
        label="$i18n{adPrivacyPageFledgeLinkRowLabel}"
        sub-label="[[computePrivacySandboxFledgeSublabel_(
                      prefs.privacy_sandbox.m1.fledge_enabled.value)]]"
        on-click="onPrivacySandboxFledgeClick_"></cr-link-row>
  </template>
  <cr-link-row
      id="privacySandboxAdMeasurementLinkRow"
      start-icon="settings20:bar-chart"
      class$="[[measurementLinkRowClass_]]"
      label="$i18n{adPrivacyPageAdMeasurementLinkRowLabel}"
      sub-label="[[computePrivacySandboxAdMeasurementSublabel_(
                    prefs.privacy_sandbox.m1.ad_measurement_enabled.value)]]"
      on-click="onPrivacySandboxAdMeasurementClick_"></cr-link-row>
</settings-subpage>
<!--_html_template_end_-->`;
}