import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">.spinner{padding-bottom:12px}#header{display:flex;justify-content:flex-start}site-favicon{margin-inline-end:2px;min-width:16px}.icon-placeholder{margin-inline-end:var(--cr-icon-button-margin-end);margin-inline-start:var(--cr-icon-button-margin-start);width:var(--cr-icon-ripple-size)}.site{flex:1}.user-name{flex:1}.user-display-name{flex:0.8}.user-display-name,.user-name,.site{align-items:center;display:inline-block;overflow:hidden;overflow-wrap:break-word;padding-inline-start:0.3rem;text-align:start}#site-header,#user-display-name-header,#user-name-header{font-weight:bold}#site-header{margin-inline-start:1rem}.edit{display:flex;flex-direction:column}#title{user-select:none}
    </style>

    <cr-dialog id="dialog" close-text="$i18n{cancel}" ignore-popstate
        on-close="onDialogClosed_">
      <div id="title" slot="title">[[dialogTitle_]]</div>

      <div slot="body">
        <cr-page-selector attr-for-selected="id" selected="[[dialogPage_]]"
            on-iron-select="onIronSelect_">
          <div id="initial">
            <p>$i18n{securityKeysTouchToContinue}</p>
            <div class="spinner"></div>
          </div>

          <div id="pinPrompt">
            <settings-security-keys-pin-field id="pin"
                min-pin-length="[[minPinLength_]]">
            </settings-security-keys-pin-field>
          </div>

          <div id="credentials">
            <div id="header" class="list-item column-header">
              <div class="site" id="site-header">
                $i18n{securityKeysCredentialWebsiteLabel}
              </div>
              <div class="user-display-name" id="user-display-name-header">
                $i18n{securityKeysCredentialDisplayNameLabel}
              </div>
              <div class="user-name" id="user-name-header">
                $i18n{securityKeysCredentialUsernameLabel}
              </div>
              <div class="icon-placeholder"></div>
              <div class="icon-placeholder"></div>
            </div>

            <div id="container">
              <iron-list id="credentialList" items="[[credentials_]]"
                  class="cr-separators list-with-header">
                <template>
                  <div class="list-item">
                    <site-favicon url="[[item.relyingPartyId]]"></site-favicon>
                    <div class="site">[[item.relyingPartyId]]</div>
                    <div class="user-display-name">
                      [[item.userDisplayName]]
                    </div>
                    <div class="user-name">[[item.userName]]</div>
                    <cr-icon-button iron-icon="cr:create"
                        aria-label="$i18n{edit}"
                        class="edit-button"
                        on-click="onUpdateButtonClick_"
                        hidden="[[!editButtonVisible_]]"
                        data-credentialid$="[[item.credentialId]]">
                    </cr-icon-button>
                    <cr-icon-button iron-icon="cr:delete"
                        aria-label="$i18n{delete}"
                        class="delete-button"
                        on-click="onDeleteButtonClick_"
                        data-credentialid$="[[item.credentialId]]">
                    </cr-icon-button>
                  </div>
                </template>
              </iron-list>
            </div>
          </div>

          <div id="edit">
            <div class="edit-item">
              <cr-input id="displayNameInput"
                  value="{{newDisplayName_}}"
                  spellcheck="false"
                  on-input="validateInput_"
                  label="$i18n{securityKeysCredentialDisplayNameLabel}"
                  error-message="[[displayNameInputError_]]"
                  invalid="[[!isEmpty_(displayNameInputError_)]]">
              </cr-input>
            </div>
            <div class="edit-item">
              <cr-input id="userNameInput"
                  value="{{newUsername_}}"
                  spellcheck="false"
                  on-input="validateInput_"
                  label="$i18n{securityKeysCredentialUsernameLabel}"
                  error-message="[[userNameInputError_]]"
                  invalid="[[!isEmpty_(userNameInputError_)]]">
              </cr-input>
            </div>
          </div>
          <div id="pinError">[[errorMsg_]]</div>
          <div id="error">[[errorMsg_]]</div>
          <div id="confirm">[[confirmMsg_]]</div>
        </cr-page-selector>
      </div>

      <div slot="button-container">
        <cr-button id="cancelButton" class="cancel-button"
            on-click="onCancelButtonClick_" hidden="[[!cancelButtonVisible_]]">
          $i18n{cancel}
        </cr-button>
        <cr-button id="confirmButton" class="action-button"
            on-click="onConfirmButtonClick_"
            disabled="[[confirmButtonDisabled_]]"
            hidden="[[!confirmButtonVisible_]]">
          [[confirmButtonLabel_]]
        </cr-button>
        <cr-button id="closeButton" class="action-button"
            on-click="close_"
            hidden="[[!closeButtonVisible_]]">
          $i18n{close}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}