import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="privacy-guide-fragment-shared"></style>
<div class="settings-fragment-header" focus-element tabindex="-1">
  <picture>
    <source
        srcset="./images/privacy_guide/history_sync_graphic_dark_v2.svg"
        media="(prefers-color-scheme: dark)">
    <img alt="" src="./images/privacy_guide/history_sync_graphic_v2.svg">
  </picture>
  <h2 class="settings-fragment-header-label">
    $i18n{privacyGuideHistorySyncCardHeader}
  </h2>
</div>
<div class="fragment-content">
  <div class="embedded-setting-wrapper">
    <settings-toggle-button id="historyToggle"
        pref="{{historySyncVirtualPref_}}"
        on-change="onToggleClick_"
        label="$i18n{privacyGuideHistorySyncSettingLabel}">
    </settings-toggle-button>
  </div>
  <div class="settings-columned-section">
    <div class="column">
      <h3 class="description-header">
        $i18n{columnHeadingWhenOn}
      </h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:history" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideHistorySyncFeatureDescription1}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:dns" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideHistorySyncFeatureDescription2}
          </div>
        </li>
      </ul>
    </div>
    <div class="column">
      <h3 class="description-header">$i18n{columnHeadingConsider}</h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:link" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideHistorySyncPrivacyDescription1}
          </div>
        </li>
      </ul>
    </div>
  </div>
</div>
<!--_html_template_end_-->`;
}