import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="settings-shared passwords-shared screen-reader-only">.misc-column{align-items:center;display:flex;justify-content:flex-end}.list-item{margin-bottom:8px;margin-top:8px}.sub-label{color:var(--cr-secondary-text-color)}#paymentsIcon{vertical-align:middle}#payOverTimeIssuerImage{line-height:0;margin-inline-end:16px;vertical-align:middle}</style>

<div class="list-item" role="row">
  <div class="type-column" role="cell">
    <picture id="payOverTimeIssuerImage">
      <source
          srcset="[[getIssuerImage_(payOverTimeIssuer.imageSrcDark)]]"
          media="(prefers-color-scheme: dark)">
      <img alt="" srcset="[[getIssuerImage_(payOverTimeIssuer.imageSrc)]]">
    </picture>
    <div class="summary-column screen-reader-only-host-node" role="cell">
      <div id="summaryLabel" class="ellipses">
        [[payOverTimeIssuer.displayName]]
      </div>
    </div>
  </div>
  <div class="misc-column" role="cell">
    <div id="paymentsIndicator">


      <span class="sub-label">$i18n{googlePayments}</span>

    </div>
    <cr-icon-button class="icon-external" id="remotePayOverTimeIssuerLink"
        title="$i18n{remotePaymentMethodsLinkLabel}" role="link"
        on-click="onRemoteEditClick_"
        aria-description="$i18n{opensInNewTab}"></cr-icon-button>
  </div>
</div>
<!--_html_template_end_-->`;
}