import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->    <style include="settings-shared passwords-shared screen-reader-only">.expiration-column,.misc-column{align-items:center;display:flex}.misc-column{justify-content:flex-end}.list-item{margin-bottom:8px;margin-top:8px}.sub-label{color:var(--cr-secondary-text-color)}#paymentsIcon{vertical-align:middle}#cardImage{margin-inline-end:16px;vertical-align:middle}
    </style>
    <div class="list-item" role="row">
      <div class="type-column" role="cell">
        <img id="cardImage" srcset="[[getCardImage_(creditCard.imageSrc)]]" alt="">
        <div class="summary-column screen-reader-only-host-node">
          <div class="screen-reader-only">
            [[getCardIdentifierAriaLabel_(creditCard)]],
            [[getSummaryAriaLabel_(creditCard)]],
            [[getSummaryAriaSublabel_(creditCard)]]
          </div>
          <template is="dom-if" if="[[!shouldShowNewFopDisplay_()]]">
            <div id="summaryLabel" class="ellipses" aria-hidden="true">
              [[creditCard.metadata.summaryLabel]]
            </div>
          </template>
          <template is="dom-if" if="[[shouldShowNewFopDisplay_()]]">
            <div>
              <span id="label" class="ellipses" aria-hidden="true">
                [[creditCard.metadata.summaryLabel]]
              </span>
              <template is="dom-if" if="[[hasCardIdentifier_(creditCard)]]">
                <div class="sub-label" aria-hidden="true">
                  <span id="summaryLabel_1">
                    [[creditCard.metadata.summarySublabel]]
                  </span>
                  <span id="summaryLabel_2">
                    [[getExpirationlabel_(creditCard)]]
                  </span>
                </div>
              </template>
              <template is="dom-if" if="[[!hasCardIdentifier_(creditCard)]]">
                <span id="expirationLabel" class="sub-label">
                  [[getExpirationlabel_(creditCard)]]
                </span>
              </template>
            </div>
          </template>
          <div id="summarySublabel" class="sub-label">
            <span aria-hidden="true">[[getSummarySublabel_(creditCard)]]</span>
            <template is="dom-if"
                if="[[hasSummaryAndBenefitSublabel_(creditCard)]]">
              |
            </template>
            <template is="dom-if" if="[[isCardBenefitsProductUrlAvailable_(creditCard)]]">
              <a id="summaryTermsLink"
                aria-label="[[getBenefitsTermsAriaLabel_(creditCard)]]"
                aria-description="$i18n{opensInNewTab}"
                on-click="onSummarySublabelTermsLinkClick_"
                href="[[getCardBenefitsProductUrl_(creditCard)]]"
                target="_blank">$i18n{benefitsTermsTagForCreditCardListEntry}</a>
            </template>
          </div>
        </div>
      </div>
      <div class="expiration-column">
        <div role="cell" class="misc-column">
          <div id="paymentsIndicator"
              hidden$="[[!shouldShowPaymentsIndicator_(creditCard.metadata)]]">
            
            
              <span class="sub-label">
                $i18n{googlePayments}
              </span>
            
          </div>
          <template is="dom-if" if="[[showDots_(creditCard.metadata)]]">
            <cr-icon-button class="icon-more-vert" id="creditCardMenu"
                title="[[moreActionsTitle_(creditCard)]]"
                on-click="onDotsMenuClick_">
            </cr-icon-button>
          </template>
          <template is="dom-if" if="[[!showDots_(creditCard.metadata)]]">
            <cr-icon-button class="icon-external" id="remoteCreditCardLink"
                title="$i18n{remotePaymentMethodsLinkLabel}" role="link"
                on-click="onRemoteEditClick_"
                aria-description="$i18n{opensInNewTab}"></cr-icon-button>
          </template>
        </div>
      </div>
    </div>
<!--_html_template_end_-->`;
}